/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.util.List;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.EditorConfigStatusUIContributor;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParserCallback;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Project project;
        VirtualFile file = psiFile.getVirtualFile();
        if (Utils.isFullIntellijSettingsSupport() && file != null && !(project = psiFile.getProject()).isDisposed() && Utils.isEnabled((CodeStyleSettings)settings)) {
            try {
                List<EditorConfig.OutPair> outPairs = EditorConfigCodeStyleSettingsModifier.getEditorConfigOptions(project, psiFile, (ParserCallback)EditorConfigNavigationActionsFactory.getInstance(file));
                if (EditorConfigCodeStyleSettingsModifier.applyCodeStyleSettings(outPairs, psiFile, (CodeStyleSettings)settings)) {
                    settings.addDependencies(EditorConfigNavigationActionsFactory.getInstance(file).getEditorConfigFiles());
                    return true;
                }
            }
            catch (EditorConfigException editorConfigException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        return new EditorConfigStatusUIContributor(transientSettings){

            @NotNull
            public String getStatusText(@NotNull PsiFile psiFile) {
                return "EditorConfig";
            }
        };
    }

    private static boolean applyCodeStyleSettings(@NotNull List<EditorConfig.OutPair> editorConfigOptions, @NotNull PsiFile file, @NotNull CodeStyleSettings settings) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)file.getLanguage());
        if (provider != null) {
            AbstractCodeStylePropertyMapper mapper = provider.getPropertyMapper(settings);
            boolean isModified = EditorConfigCodeStyleSettingsModifier.processOptions(editorConfigOptions, mapper, false);
            isModified = EditorConfigCodeStyleSettingsModifier.processOptions(editorConfigOptions, mapper, true) || isModified;
            return isModified;
        }
        return false;
    }

    private static boolean processOptions(@NotNull List<EditorConfig.OutPair> editorConfigOptions, @NotNull AbstractCodeStylePropertyMapper mapper, boolean languageSpecific) {
        String ideLangPrefix = EditorConfigIntellijNameUtil.getIdeLangPrefix(mapper);
        boolean isModified = false;
        for (EditorConfig.OutPair option : editorConfigOptions) {
            CodeStylePropertyAccessor accessor;
            String intellijName;
            if (languageSpecific && !option.getKey().startsWith(ideLangPrefix) || (intellijName = EditorConfigIntellijNameUtil.toIntellijName(mapper, option.getKey())) == null || (accessor = mapper.getAccessor(intellijName)) == null) continue;
            isModified |= accessor.setFromString(option.getVal());
        }
        return isModified;
    }

    private static List<EditorConfig.OutPair> getEditorConfigOptions(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ParserCallback callback) throws EditorConfigException {
        String filePath = Utils.getFilePath(project, psiFile.getVirtualFile());
        Set<String> rootDirs = SettingsProviderComponent.getInstance().getRootDirs(project);
        return new EditorConfig().getProperties(filePath, rootDirs, callback);
    }
}

