/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigIntellijNameUtil {
    private static final String IDE_PREFIX = "ij_";
    private static final String GENERIC_PROPERTY_PREFIX = "any_";

    private EditorConfigIntellijNameUtil() {
    }

    public static List<String> toEditorConfigNames(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        ArrayList names = ContainerUtil.newArrayList();
        CodeStylePropertyAccessor accessor = mapper.getAccessor(propertyName);
        if (accessor.isGenericProperty()) {
            names.add("ij_any_" + propertyName);
        }
        String langPrefix = mapper.getLanguageDomainId() + "_";
        names.add(IDE_PREFIX + langPrefix + propertyName);
        return names;
    }

    @Nullable
    public static String toIntellijName(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String editorConfigName) {
        if (mapper.containsProperty(editorConfigName)) {
            return editorConfigName;
        }
        if (editorConfigName.startsWith(IDE_PREFIX)) {
            String withoutSuffix = editorConfigName.substring(IDE_PREFIX.length());
            if (mapper.containsProperty(withoutSuffix)) {
                return withoutSuffix;
            }
            int nextUnderscorePos = withoutSuffix.indexOf(95);
            if (nextUnderscorePos > 0 && nextUnderscorePos < withoutSuffix.length() && editorConfigName.contains(withoutSuffix = withoutSuffix.substring(nextUnderscorePos + 1))) {
                return withoutSuffix;
            }
        }
        return null;
    }

    static String getIdeLangPrefix(@NotNull AbstractCodeStylePropertyMapper mapper) {
        return IDE_PREFIX + mapper.getLanguageDomainId() + "_";
    }
}

