/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.annotators;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.editorconfig.language.highlighting.EditorConfigSyntaxHighlighter;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigAsteriskPattern;
import org.editorconfig.language.psi.EditorConfigCharClassExclamation;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.psi.EditorConfigDoubleAsteriskPattern;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigFlatOptionKey;
import org.editorconfig.language.psi.EditorConfigFlatPattern;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigQualifiedKeyPart;
import org.editorconfig.language.psi.EditorConfigQualifiedOptionKey;
import org.editorconfig.language.psi.EditorConfigQuestionPattern;
import org.editorconfig.language.psi.EditorConfigRootDeclarationKey;
import org.editorconfig.language.psi.EditorConfigRootDeclarationValue;
import org.editorconfig.language.psi.EditorConfigVisitor;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/editorconfig/language/codeinsight/annotators/EditorConfigAnnotatorVisitor;", "Lorg/editorconfig/language/psi/EditorConfigVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkDanglingKey", "", "option", "Lorg/editorconfig/language/psi/EditorConfigOption;", "checkEdgeDots", "edgeElement", "Lcom/intellij/psi/PsiElement;", "neighbourElement", "checkInnerDots", "key", "Lorg/editorconfig/language/psi/EditorConfigQualifiedOptionKey;", "checkLineBreaks", "visitAsteriskPattern", "pattern", "Lorg/editorconfig/language/psi/EditorConfigAsteriskPattern;", "visitCharClassExclamation", "exclamation", "Lorg/editorconfig/language/psi/EditorConfigCharClassExclamation;", "visitCharClassLetter", "letter", "Lorg/editorconfig/language/psi/EditorConfigCharClassLetter;", "visitDoubleAsteriskPattern", "Lorg/editorconfig/language/psi/EditorConfigDoubleAsteriskPattern;", "visitFlatOptionKey", "flatKey", "Lorg/editorconfig/language/psi/EditorConfigFlatOptionKey;", "visitFlatPattern", "flatPattern", "Lorg/editorconfig/language/psi/EditorConfigFlatPattern;", "visitOption", "visitOptionValueIdentifier", "identifier", "Lorg/editorconfig/language/psi/EditorConfigOptionValueIdentifier;", "visitQualifiedKeyPart", "keyPart", "Lorg/editorconfig/language/psi/EditorConfigQualifiedKeyPart;", "visitQualifiedOptionKey", "visitQuestionPattern", "Lorg/editorconfig/language/psi/EditorConfigQuestionPattern;", "visitRootDeclarationKey", "Lorg/editorconfig/language/psi/EditorConfigRootDeclarationKey;", "visitRootDeclarationValue", "value", "Lorg/editorconfig/language/psi/EditorConfigRootDeclarationValue;", "intellij.editorconfig"})
public final class EditorConfigAnnotatorVisitor
extends EditorConfigVisitor {
    private final AnnotationHolder holder;

    @Override
    public void visitQualifiedOptionKey(@NotNull EditorConfigQualifiedOptionKey key) {
        this.checkEdgeDots(key.getFirstChild(), key.getFirstChild().getNextSibling());
        this.checkEdgeDots(key.getLastChild(), key.getLastChild().getPrevSibling());
        this.checkInnerDots(key);
    }

    private final void checkInnerDots(EditorConfigQualifiedOptionKey key) {
        PsiElement firstDot = null;
        PsiElement lastDot = null;
        Iterable $receiver$iv = (Iterable)SyntaxTraverser.psiTraverser().children((Object)key);
        for (Object element$iv : $receiver$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)EditorConfigElementTypes.DOT)) {
                if (firstDot == null) {
                    firstDot = it;
                }
                lastDot = it;
                continue;
            }
            if (Intrinsics.areEqual((Object)firstDot, (Object)lastDot) ^ true) {
                String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.multiple-dots");
                PsiElement psiElement = firstDot;
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                int start = psiElement.getTextRange().getStartOffset();
                PsiElement psiElement2 = lastDot;
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                int end = psiElement2.getTextRange().getEndOffset();
                TextRange range = TextRange.create((int)start, (int)end);
                this.holder.createErrorAnnotation(range, message2);
                firstDot = null;
                lastDot = null;
                continue;
            }
            firstDot = null;
            lastDot = null;
        }
    }

    private final void checkEdgeDots(PsiElement edgeElement, PsiElement neighbourElement) {
        if (Intrinsics.areEqual((Object)edgeElement.getNode().getElementType(), (Object)EditorConfigElementTypes.DOT) ^ true) {
            return;
        }
        PsiElement psiElement = neighbourElement;
        if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)EditorConfigElementTypes.DOT)) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.key.dangling-dot");
        this.holder.createErrorAnnotation(edgeElement, message2);
    }

    @Override
    public void visitOption(@NotNull EditorConfigOption option) {
        this.checkDanglingKey(option);
        this.checkLineBreaks(option);
    }

    private final void checkLineBreaks(EditorConfigOption option) {
        if (!option.textContains('\n')) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.option.suspicious.line.break");
        this.holder.createErrorAnnotation((PsiElement)option, message2);
    }

    private final void checkDanglingKey(EditorConfigOption option) {
        if (option.getAnyValue() != null) {
            return;
        }
        String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.dangling.key");
        this.holder.createErrorAnnotation((PsiElement)option, message2);
    }

    @Override
    public void visitFlatOptionKey(@NotNull EditorConfigFlatOptionKey flatKey) {
        this.holder.createInfoAnnotation((PsiElement)flatKey, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY());
    }

    @Override
    public void visitQualifiedKeyPart(@NotNull EditorConfigQualifiedKeyPart keyPart) {
        EditorConfigDescriptor descriptor = keyPart.getDescriptor(false);
        this.holder.createInfoAnnotation((PsiElement)keyPart, null).setTextAttributes(descriptor instanceof EditorConfigDeclarationDescriptor ? EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY() : EditorConfigSyntaxHighlighter.INSTANCE.getKEY_DESCRIPTION());
    }

    @Override
    public void visitOptionValueIdentifier(@NotNull EditorConfigOptionValueIdentifier identifier) {
        this.holder.createInfoAnnotation((PsiElement)identifier, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE());
    }

    @Override
    public void visitFlatPattern(@NotNull EditorConfigFlatPattern flatPattern) {
        this.holder.createInfoAnnotation((PsiElement)flatPattern, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN());
        if (!flatPattern.textContains('\\')) {
            return;
        }
        String text = flatPattern.getText();
        int offset = flatPattern.getTextOffset();
        for (int index = 0; index < text.length(); ++index) {
            if (text.charAt(index) != '\\') continue;
            TextRange range = new TextRange(offset + index, offset + index + 2);
            if (StringsKt.contains$default((CharSequence)" \r\n\t\\#;!?*[]{}", (char)text.charAt(++index), (boolean)false, (int)2, null)) {
                this.holder.createInfoAnnotation(range, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE());
                continue;
            }
            String message2 = EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape");
            this.holder.createInfoAnnotation(range, message2).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE());
        }
    }

    @Override
    public void visitAsteriskPattern(@NotNull EditorConfigAsteriskPattern pattern) {
        this.holder.createInfoAnnotation((PsiElement)pattern, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getSPECIAL_SYMBOL());
    }

    @Override
    public void visitDoubleAsteriskPattern(@NotNull EditorConfigDoubleAsteriskPattern pattern) {
        this.holder.createInfoAnnotation((PsiElement)pattern, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getSPECIAL_SYMBOL());
    }

    @Override
    public void visitCharClassExclamation(@NotNull EditorConfigCharClassExclamation exclamation) {
        this.holder.createInfoAnnotation((PsiElement)exclamation, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getSPECIAL_SYMBOL());
    }

    @Override
    public void visitQuestionPattern(@NotNull EditorConfigQuestionPattern pattern) {
        this.holder.createInfoAnnotation((PsiElement)pattern, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getSPECIAL_SYMBOL());
    }

    @Override
    public void visitCharClassLetter(@NotNull EditorConfigCharClassLetter letter) {
        if (!letter.isEscape()) {
            this.holder.createInfoAnnotation((PsiElement)letter, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN());
        } else if (letter.isValidEscape()) {
            this.holder.createInfoAnnotation((PsiElement)letter, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE());
        } else {
            this.holder.createInfoAnnotation((PsiElement)letter, EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape")).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE());
        }
    }

    @Override
    public void visitRootDeclarationKey(@NotNull EditorConfigRootDeclarationKey key) {
        this.holder.createInfoAnnotation((PsiElement)key, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY());
    }

    @Override
    public void visitRootDeclarationValue(@NotNull EditorConfigRootDeclarationValue value) {
        this.holder.createInfoAnnotation((PsiElement)value, null).setTextAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE());
    }

    public EditorConfigAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        this.holder = holder;
    }
}

