/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigOptionValueList;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "findClosestListElement", "Lorg/editorconfig/language/psi/EditorConfigOptionValueIdentifier;", "list", "Lorg/editorconfig/language/psi/EditorConfigOptionValueList;", "getFamilyName", "", "intellij.editorconfig"})
public final class EditorConfigRemoveUnexpectedValuesQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.value.list.remove.others");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.editorconfig.language.psi.EditorConfigOptionValueList");
        }
        EditorConfigOptionValueList list = (EditorConfigOptionValueList)psiElement;
        EditorConfigOptionValueIdentifier editorConfigOptionValueIdentifier = this.findClosestListElement(list);
        if (editorConfigOptionValueIdentifier == null) {
            return;
        }
        EditorConfigOptionValueIdentifier identifier = editorConfigOptionValueIdentifier;
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigOptionValueIdentifier replacement = factory.createValueIdentifier(identifier.getText());
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(list, replacement){
            final /* synthetic */ EditorConfigOptionValueList $list;
            final /* synthetic */ EditorConfigOptionValueIdentifier $replacement;

            public final void run() {
                this.$list.replace(this.$replacement);
            }
            {
                this.$list = editorConfigOptionValueList;
                this.$replacement = editorConfigOptionValueIdentifier;
            }
        });
    }

    private final EditorConfigOptionValueIdentifier findClosestListElement(EditorConfigOptionValueList list) {
        Object v1;
        Editor editor = FileEditorManager.getInstance((Project)list.getProject()).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        Iterable $receiver$iv = list.getOptionValueIdentifierList();
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            PsiElement element = (PsiElement)minElem$iv;
            boolean bl = false;
            int n = element.getTextRange().getStartOffset() - editor2.getCaretModel().getOffset();
            n = Math.abs(n);
            int n2 = element.getTextRange().getEndOffset() - editor2.getCaretModel().getOffset();
            n2 = Math.abs(n2);
            int minValue$iv = Math.min(n, n2);
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                PsiElement element2 = (PsiElement)e$iv;
                $i$a$-minBy-EditorConfigRemoveUnexpectedValuesQuickFix$findClosestListElement$1 = false;
                int n3 = element2.getTextRange().getStartOffset() - editor2.getCaretModel().getOffset();
                n3 = Math.abs(n3);
                int n4 = element2.getTextRange().getEndOffset() - editor2.getCaretModel().getOffset();
                int v$iv = Math.min(n3, n4 = Math.abs(n4));
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v1 = minElem$iv;
        }
        return v1;
    }
}

