/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.services.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.reference.SoftReference;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.reference.EditorConfigVirtualFileDescriptor;
import org.editorconfig.language.services.EditorConfigFileHierarchyService;
import org.editorconfig.language.services.EditorConfigServiceLoaded;
import org.editorconfig.language.services.EditorConfigServiceLoading;
import org.editorconfig.language.services.EditorConfigServiceResult;
import org.editorconfig.language.services.impl.EditorConfigFileHierarchyServiceImpl;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001*B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl;", "Lorg/editorconfig/language/services/EditorConfigFileHierarchyService;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "manager", "Lcom/intellij/psi/PsiManager;", "application", "Lcom/intellij/openapi/application/Application;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/project/Project;)V", "affectingFilesCache", "Lcom/intellij/util/containers/FixedHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/lang/ref/Reference;", "", "Lorg/editorconfig/language/psi/EditorConfigPsiFile;", "cacheDropsCount", "", "cacheLocker", "", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "after", "", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "afterValueChanged", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "beforeValueChanged", "findApplicableFiles", "virtualFile", "findParentFiles", "file", "findParentPsiFiles", "getParentEditorConfigFiles", "Lorg/editorconfig/language/services/EditorConfigServiceResult;", "startBackgroundTask", "updateHandlers", "Companion", "intellij.editorconfig"})
public final class EditorConfigFileHierarchyServiceImpl
extends EditorConfigFileHierarchyService
implements BulkFileListener,
RegistryValueListener {
    private final ExecutorService taskExecutor;
    private final MergingUpdateQueue updateQueue;
    private volatile int cacheDropsCount;
    private final Object cacheLocker;
    private final FixedHashMap<VirtualFile, Reference<List<EditorConfigPsiFile>>> affectingFilesCache;
    private final PsiManager manager;
    private final Application application;
    private final Project project;
    private static final Logger Log;
    private static final int CacheSize = 10;
    @Deprecated
    public static final Companion Companion;

    private final void updateHandlers(Project project) {
        this.updateQueue.queue(Update.create((Object)"editorconfig hierarchy update", (Runnable)new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                CodeStyleSettingsManager.getInstance((Project)this.$project).fireCodeStyleSettingsChanged(null);
            }
            {
                this.$project = project;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        List editorConfigs2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)after.editorConfigs.1.INSTANCE), (Function1)after.editorConfigs.2.INSTANCE), (Function1)after.editorConfigs.3.INSTANCE));
        Object object = editorConfigs2;
        if (!object.isEmpty()) {
            object = this.cacheLocker;
            synchronized (object) {
                boolean bl = false;
                ++this.cacheDropsCount;
                this.affectingFilesCache.clear();
                Unit unit = Unit.INSTANCE;
            }
            this.updateHandlers(this.project);
        }
    }

    public void beforeValueChanged(@NotNull RegistryValue value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterValueChanged(@NotNull RegistryValue value) {
        Object object = this.cacheLocker;
        synchronized (object) {
            boolean bl = false;
            ++this.cacheDropsCount;
            this.affectingFilesCache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EditorConfigServiceResult getParentEditorConfigFiles(@NotNull VirtualFile virtualFile) {
        Reference reference;
        Object object = this.cacheLocker;
        synchronized (object) {
            boolean bl = false;
            reference = (Reference)this.affectingFilesCache.get((Object)virtualFile);
        }
        List cachedResult = (List)SoftReference.dereference((Reference)reference);
        if (cachedResult != null) {
            return new EditorConfigServiceLoaded(cachedResult);
        }
        this.startBackgroundTask(virtualFile);
        return EditorConfigServiceLoading.INSTANCE;
    }

    private final void startBackgroundTask(VirtualFile virtualFile) {
        int expectedCacheDropsCount = this.cacheDropsCount;
        ReadAction.nonBlocking((Callable)new Callable<T>(this, virtualFile){
            final /* synthetic */ EditorConfigFileHierarchyServiceImpl this$0;
            final /* synthetic */ VirtualFile $virtualFile;

            @Nullable
            public final List<EditorConfigPsiFile> call() {
                return EditorConfigFileHierarchyServiceImpl.access$findApplicableFiles(this.this$0, this.$virtualFile);
            }
            {
                this.this$0 = editorConfigFileHierarchyServiceImpl;
                this.$virtualFile = virtualFile;
            }
        }).expireWhen(new BooleanSupplier(this){
            final /* synthetic */ EditorConfigFileHierarchyServiceImpl this$0;

            public final boolean getAsBoolean() {
                return EditorConfigFileHierarchyServiceImpl.access$getProject$p(this.this$0).isDisposed();
            }
            {
                this.this$0 = editorConfigFileHierarchyServiceImpl;
            }
        }).finishOnUiThread(ModalityState.any(), (Consumer)new Consumer<List<? extends EditorConfigPsiFile>>(this, expectedCacheDropsCount, virtualFile){
            final /* synthetic */ EditorConfigFileHierarchyServiceImpl this$0;
            final /* synthetic */ int $expectedCacheDropsCount;
            final /* synthetic */ VirtualFile $virtualFile;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@Nullable List<EditorConfigPsiFile> affectingFiles) {
                if (affectingFiles == null) {
                    return;
                }
                Object object = EditorConfigFileHierarchyServiceImpl.access$getCacheLocker$p(this.this$0);
                synchronized (object) {
                    boolean bl = false;
                    if (this.$expectedCacheDropsCount != EditorConfigFileHierarchyServiceImpl.access$getCacheDropsCount$p(this.this$0)) {
                        return;
                    }
                    Map map = (Map)EditorConfigFileHierarchyServiceImpl.access$getAffectingFilesCache$p(this.this$0);
                    VirtualFile virtualFile = this.$virtualFile;
                    SoftReference softReference = new SoftReference(affectingFiles);
                    map.put(virtualFile, softReference);
                    map = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = editorConfigFileHierarchyServiceImpl;
                this.$expectedCacheDropsCount = n;
                this.$virtualFile = virtualFile;
            }
        }).submit((Executor)this.taskExecutor);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigPsiFile> findApplicableFiles(VirtualFile virtualFile) {
        List list;
        List<EditorConfigPsiFile> parentFiles;
        List<EditorConfigPsiFile> list2;
        Log.assertTrue(!this.application.isDispatchThread());
        this.application.assertReadAccessAllowed();
        int expectedCacheDropsCount = this.cacheDropsCount;
        if (!EditorConfigRegistry.shouldStopAtProjectRoot()) {
            list2 = this.findParentPsiFiles(virtualFile);
        } else {
            PsiFile psiFile = this.manager.findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            list2 = EditorConfigPsiTreeUtil.INSTANCE.findAllParentsFiles(psiFile);
        }
        List<EditorConfigPsiFile> list3 = parentFiles = list2;
        if (list3 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                boolean bl;
                block10: {
                    EditorConfigPsiFile parent = (EditorConfigPsiFile)((Object)element$iv$iv);
                    boolean bl2 = false;
                    Iterable $receiver$iv2 = parent.getSections();
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            EditorConfigSection section = (EditorConfigSection)element$iv;
                            boolean bl3 = false;
                            if (expectedCacheDropsCount != this.cacheDropsCount) {
                                return null;
                            }
                            ProgressIndicatorProvider.checkCanceled();
                            EditorConfigHeader header = section.getHeader();
                            boolean bl4 = header.isValidGlob() ? EditorConfigGlobUtilsKt.matches(header, virtualFile) : false;
                            if (!bl4) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigPsiFile> findParentPsiFiles(VirtualFile file) {
        int firstRoot;
        Sequence parents2;
        int expectedCacheDropsCount;
        block8: {
            int n;
            Sequence sequence;
            block10: {
                block9: {
                    void $receiver$iv;
                    Log.assertTrue(!this.application.isDispatchThread());
                    this.application.assertReadAccessAllowed();
                    expectedCacheDropsCount = this.cacheDropsCount;
                    sequence = this.findParentFiles(file);
                    if (sequence == null || (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) == null) break block9;
                    Sequence sequence2 = sequence;
                    void var6_6 = $receiver$iv;
                    EditorConfigVirtualFileDescriptor editorConfigVirtualFileDescriptor = new EditorConfigVirtualFileDescriptor(file);
                    Comparator comparator = new Comparator<T>(editorConfigVirtualFileDescriptor){
                        final /* synthetic */ EditorConfigVirtualFileDescriptor receiver$0$inlined;
                        {
                            this.receiver$0$inlined = editorConfigVirtualFileDescriptor;
                        }

                        public final int compare(T a, T b) {
                            VirtualFile p1 = (VirtualFile)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(this.receiver$0$inlined.distanceToParent(p1));
                            p1 = (VirtualFile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            Integer n = this.receiver$0$inlined.distanceToParent(p1);
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    };
                    sequence = SequencesKt.sortedWith((Sequence)var6_6, (Comparator)comparator);
                    if (sequence != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)new Function1<VirtualFile, EditorConfigPsiFile>(this){
                        final /* synthetic */ EditorConfigFileHierarchyServiceImpl this$0;

                        @Nullable
                        public final EditorConfigPsiFile invoke(@NotNull VirtualFile it) {
                            PsiFile psiFile = EditorConfigFileHierarchyServiceImpl.access$getManager$p(this.this$0).findFile(it);
                            if (!(psiFile instanceof EditorConfigPsiFile)) {
                                psiFile = null;
                            }
                            return (EditorConfigPsiFile)psiFile;
                        }
                        {
                            this.this$0 = editorConfigFileHierarchyServiceImpl;
                            super(1);
                        }
                    }))) != null) break block10;
                }
                return null;
            }
            Sequence $receiver$iv = parents2 = sequence;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object receiver = item$iv;
                boolean bl = false;
                if (((EditorConfigPsiFile)((Object)receiver)).getHasValidRootDeclaration()) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = firstRoot = -1;
        }
        if (this.cacheDropsCount != expectedCacheDropsCount) {
            return null;
        }
        ProgressManager.checkCanceled();
        return firstRoot < 0 ? SequencesKt.toList((Sequence)parents2) : SequencesKt.toList((Sequence)SequencesKt.take((Sequence)parents2, (int)(firstRoot + 1)));
    }

    private final List<VirtualFile> findParentFiles(VirtualFile file) {
        Log.assertTrue(!this.application.isDispatchThread());
        this.application.assertReadAccessAllowed();
        String fileName = ".editorconfig";
        int expectedCacheDropsCount = this.cacheDropsCount;
        List result2 = new ArrayList();
        for (VirtualFile currentFolder = file.getParent(); currentFolder != null; currentFolder = currentFolder.getParent()) {
            if (this.cacheDropsCount != expectedCacheDropsCount) {
                return null;
            }
            ProgressManager.checkCanceled();
            VirtualFile child = currentFolder.findChild(fileName);
            if (child == null || child.isDirectory()) continue;
            result2.add(child);
        }
        return result2;
    }

    public EditorConfigFileHierarchyServiceImpl(@NotNull PsiManager manager, @NotNull Application application, @NotNull Project project) {
        this.manager = manager;
        this.application = application;
        this.project = project;
        this.taskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"editorconfig.notification.vfs.update.executor");
        this.updateQueue = new MergingUpdateQueue("EditorConfigFileHierarchy UpdateQueue", 500, true, null, (Disposable)this.project);
        this.cacheLocker = new Object();
        this.affectingFilesCache = new FixedHashMap(10);
        DumbService.getInstance((Project)this.project).runWhenSmart(new Runnable(){

            @Override
            public final void run() {
                application.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
            }
        });
        Registry.get((String)"editor.config.stop.at.project.root").addListener((RegistryValueListener)this, (Disposable)this.project);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Log = Logger.getInstance(EditorConfigFileHierarchyService.class);
    }

    public static final /* synthetic */ List access$findApplicableFiles(EditorConfigFileHierarchyServiceImpl $this, VirtualFile virtualFile) {
        return $this.findApplicableFiles(virtualFile);
    }

    public static final /* synthetic */ Object access$getCacheLocker$p(EditorConfigFileHierarchyServiceImpl $this) {
        return $this.cacheLocker;
    }

    public static final /* synthetic */ int access$getCacheDropsCount$p(EditorConfigFileHierarchyServiceImpl $this) {
        return $this.cacheDropsCount;
    }

    public static final /* synthetic */ void access$setCacheDropsCount$p(EditorConfigFileHierarchyServiceImpl $this, int n) {
        $this.cacheDropsCount = n;
    }

    public static final /* synthetic */ FixedHashMap access$getAffectingFilesCache$p(EditorConfigFileHierarchyServiceImpl $this) {
        return $this.affectingFilesCache;
    }

    public static final /* synthetic */ PsiManager access$getManager$p(EditorConfigFileHierarchyServiceImpl $this) {
        return $this.manager;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl$Companion;", "", "()V", "CacheSize", "", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.editorconfig"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

