/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import dk.brics.automaton.Automaton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.core.EditorConfigAutomatonBuilder;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPattern;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0004\u001a\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Log", "Lcom/intellij/openapi/diagnostic/Logger;", "isEquivalentTo", "", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "other", "isSubcaseOf", "general", "Lorg/editorconfig/language/psi/EditorConfigPattern;", "generalAutomaton", "Ldk/brics/automaton/Automaton;", "matches", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "string", "", "intellij.editorconfig"})
public final class EditorConfigGlobUtilsKt {
    private static final Logger Log;

    public static final boolean isSubcaseOf(@NotNull EditorConfigHeader $receiver, @NotNull EditorConfigHeader general) {
        if (!$receiver.isValidGlob()) {
            return false;
        }
        if (!general.isValidGlob()) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($receiver);
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(general);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean isEquivalentTo(@NotNull EditorConfigHeader $receiver, @NotNull EditorConfigHeader other) {
        if (!$receiver.getHeader().isValidGlob()) {
            return false;
        }
        if (!other.getHeader().isValidGlob()) {
            return false;
        }
        Automaton thisAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton($receiver);
        Automaton otherAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderAutomaton(other);
        return Intrinsics.areEqual((Object)thisAutomaton, (Object)otherAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $receiver, @NotNull EditorConfigPattern general) {
        if (!general.getHeader().isValidGlob()) {
            return false;
        }
        Automaton generalAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton(general);
        return EditorConfigGlobUtilsKt.isSubcaseOf($receiver, generalAutomaton);
    }

    public static final boolean isSubcaseOf(@NotNull EditorConfigPattern $receiver, @NotNull Automaton generalAutomaton) {
        if (!$receiver.getHeader().isValidGlob()) {
            return false;
        }
        Automaton subcaseAutomaton = EditorConfigAutomatonBuilder.INSTANCE.getCachedPatternAutomaton($receiver);
        return subcaseAutomaton.subsetOf(generalAutomaton);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $receiver, @NotNull String string) {
        Log.assertTrue($receiver.getHeader().isValidGlob());
        return EditorConfigAutomatonBuilder.INSTANCE.getCachedHeaderRunAutomaton($receiver.getSection().getHeader()).run(string);
    }

    public static final boolean matches(@NotNull EditorConfigHeader $receiver, @NotNull VirtualFile file) {
        Log.assertTrue($receiver.getHeader().isValidGlob());
        return EditorConfigGlobUtilsKt.matches($receiver, file.getPath());
    }

    static {
        boolean $i$f$logger = false;
        Log = Logger.getInstance(EditorConfigHeader.class);
    }
}

