/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.tooling.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelsHolder<K extends Model, V>
implements Serializable {
    @NotNull
    private final K myRootModel;
    @NotNull
    private final Map<String, Object> myModelsById = new HashMap<String, Object>();

    public ModelsHolder(@NotNull K rootModel) {
        this.myRootModel = rootModel;
    }

    @NotNull
    public K getRootModel() {
        return this.myRootModel;
    }

    @Nullable
    public <T> T getExtraProject(Class<T> modelClazz) {
        return this.getExtraProject(null, modelClazz);
    }

    @Nullable
    public <T> T getExtraProject(@Nullable V model, Class<T> modelClazz) {
        Object project = this.myModelsById.get(this.extractMapKey(modelClazz, model));
        if (modelClazz.isInstance(project)) {
            return (T)project;
        }
        return null;
    }

    @NotNull
    public Collection<String> findModulesWithModel(@NotNull Class modelClazz) {
        ArrayList<String> modules = new ArrayList<String>();
        for (Map.Entry<String, Object> set : this.myModelsById.entrySet()) {
            if (!modelClazz.isInstance(set.getValue())) continue;
            modules.add(ModelsHolder.extractModulePath(modelClazz, set.getKey()));
        }
        return modules;
    }

    public boolean hasModulesWithModel(@NotNull Class modelClazz) {
        for (Map.Entry<String, Object> set : this.myModelsById.entrySet()) {
            if (!modelClazz.isInstance(set.getValue())) continue;
            return true;
        }
        return false;
    }

    public void addExtraProject(@NotNull Object project, @NotNull Class modelClazz) {
        this.myModelsById.put(this.extractMapKey(modelClazz, null), project);
    }

    public void addExtraProject(@NotNull Object project, @NotNull Class modelClazz, @Nullable V subPropject) {
        this.myModelsById.put(this.extractMapKey(modelClazz, subPropject), project);
    }

    @NotNull
    protected abstract String extractMapKey(Class var1, @Nullable V var2);

    @NotNull
    private static String extractModulePath(Class modelClazz, String key) {
        return key.replaceFirst(modelClazz.getName() + '@', "");
    }

    public String toString() {
        return "Models{rootModel=" + this.myRootModel + ", myModelsById=" + this.myModelsById + '}';
    }
}

