/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorMessageBuilder {
    public static final String GROUP_TAG = "<ij_msg_gr>";
    public static final String NAV_TAG = "<ij_nav>";
    public static final String EOL_TAG = "<eol>";
    @NotNull
    private final Project myProject;
    @Nullable
    private final Exception myException;
    @NotNull
    private final String myGroup;
    @Nullable
    private String myDescription;

    private ErrorMessageBuilder(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        this.myProject = project;
        this.myException = exception;
        this.myGroup = group;
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @NotNull String group) {
        return new ErrorMessageBuilder(project, null, group);
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        return new ErrorMessageBuilder(project, exception, group);
    }

    public ErrorMessageBuilder withDescription(@NotNull String description) {
        this.myDescription = description;
        return this;
    }

    public String build() {
        String group = this.myGroup.replaceAll("\r\n|\n\r|\n|\r", " ");
        File projectBuildFile = this.myProject.getBuildFile();
        return GROUP_TAG + group + GROUP_TAG + (projectBuildFile != null ? NAV_TAG + projectBuildFile.getPath() + NAV_TAG : "") + ("<i><b>" + this.myProject + (this.myDescription != null ? ": " + this.myDescription : "") + "</b>" + (this.myException != null ? "\nDetails: " + ErrorMessageBuilder.getErrorMessage(this.myException) : "") + "</i>").replaceAll("\r\n|\n\r|\n|\r", EOL_TAG);
    }

    private static String getErrorMessage(@NotNull Throwable e) {
        if (Boolean.valueOf(System.getProperty("idea.tooling.debug")).booleanValue()) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
        StringBuilder buf = new StringBuilder();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (buf.length() != 0) {
                buf.append("\nCaused by: ");
            }
            buf.append(cause.getClass().getName()).append(": ").append(cause.getMessage());
        }
        return buf.toString();
    }
}

