/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.deploy;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.appengine.v1.model.Application;
import com.google.gct.idea.appengine.admin.AppEngineAdminService;
import com.google.gct.idea.appengine.admin.GoogleApiException;
import com.google.gct.studio.deploy.AppEngineApplicationCreateDialog;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import git4idea.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AppEngineApplicationInfoPanel
extends JPanel {
    private static final String HTML_OPEN_TAG = "<html><font face='sans' size='-1'>";
    private static final String HTML_CLOSE_TAG = "</font></html>";
    private static final String CREATE_APPLICATION_HREF_OPEN_TAG = "<a href='#'>";
    private static final String HREF_CLOSE_TAG = "</a>";
    private static final int COMPONENTS_HORIZONTAL_PADDING = 5;
    private final JLabel errorIcon = new JLabel(AllIcons.Ide.Error);
    private final JTextPane messageText;
    private boolean isApplicationValid = true;
    private CreateApplicationLinkListener currentLinkListener;

    public AppEngineApplicationInfoPanel() {
        super(new BorderLayout(5, 0));
        this.errorIcon.setVisible(false);
        this.errorIcon.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.messageText = new JTextPane();
        this.messageText.setContentType("text/html");
        this.messageText.setEditable(false);
        this.messageText.setOpaque(false);
        this.add((Component)this.errorIcon, "West");
        this.add(this.messageText);
    }

    public void refresh(String projectId, Credential credential) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Application application = AppEngineAdminService.getInstance().getApplicationForProjectId(projectId, credential);
                if (application != null) {
                    this.setMessage(application.getLocationId(), false);
                    this.isApplicationValid = true;
                } else {
                    this.setCreateApplicationMessage(projectId, credential);
                    this.isApplicationValid = false;
                }
            }
            catch (GoogleApiException | IOException e) {
                this.setMessage(GctStudioBundle.message("appengine.application.region.fetch.error", new Object[0]), true);
                this.isApplicationValid = false;
            }
        });
    }

    public boolean isApplicationValid() {
        return this.isApplicationValid;
    }

    private void setMessage(String message, boolean isError) {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.errorIcon.setVisible(false);
            this.messageText.setText(HTML_OPEN_TAG + message + HTML_CLOSE_TAG);
            this.messageText.setForeground((Color)(isError ? JBColor.red : JBColor.black));
        }, ModalityState.stateForComponent((Component)this));
    }

    private void setCreateApplicationMessage(String projectId, Credential credential) {
        if (this.currentLinkListener != null) {
            this.messageText.removeHyperlinkListener(this.currentLinkListener);
        }
        this.currentLinkListener = new CreateApplicationLinkListener(projectId, credential);
        this.messageText.addHyperlinkListener(this.currentLinkListener);
        ApplicationManager.getApplication().invokeLater(() -> {
            String message = GctStudioBundle.message("appengine.application.not.exist", new Object[0]) + " " + GctStudioBundle.message("appengine.application.create", CREATE_APPLICATION_HREF_OPEN_TAG, HREF_CLOSE_TAG);
            this.messageText.setText(HTML_OPEN_TAG + message + HTML_CLOSE_TAG);
            this.messageText.setForeground((Color)JBColor.red);
            this.errorIcon.setVisible(true);
        }, ModalityState.stateForComponent((Component)this));
    }

    private class CreateApplicationLinkListener
    implements HyperlinkListener {
        private final Credential credential;
        private final String projectId;

        public CreateApplicationLinkListener(String projectId, Credential credential) {
            this.projectId = projectId;
            this.credential = credential;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AppEngineApplicationCreateDialog applicationDialog = new AppEngineApplicationCreateDialog(AppEngineApplicationInfoPanel.this, this.projectId, this.credential);
                DialogManager.show((DialogWrapper)applicationDialog);
                applicationDialog.getDisposable().dispose();
                if (applicationDialog.getExitCode() == 0) {
                    AppEngineApplicationInfoPanel.this.refresh(this.projectId, this.credential);
                }
            }
        }
    }
}

