/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import icons.TestngIcons;
import org.jetbrains.annotations.NotNull;

public final class TestNGConfigurationType
extends SimpleConfigurationType {
    public TestNGConfigurationType() {
        super("TestNG", "TestNG", null, NotNullLazyValue.createValue(() -> TestngIcons.TestNG));
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        return new TestNGConfiguration(project, (ConfigurationFactory)this);
    }

    @NotNull
    public String getTag() {
        return "testNg";
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.TestNG";
    }

    @NotNull
    public static TestNGConfigurationType getInstance() {
        return (TestNGConfigurationType)ConfigurationTypeUtil.findConfigurationType(TestNGConfigurationType.class);
    }

    public boolean isConfigurationByLocation(RunConfiguration runConfiguration, Location location) {
        TestNGConfiguration config = (TestNGConfiguration)runConfiguration;
        TestData testObject = config.getPersistantData();
        if (testObject == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        TestNGTestObject testNGTestObject = TestNGTestObject.fromConfig(config);
        if (testNGTestObject.isConfiguredByElement(element)) {
            Module configurationModule = ((JavaRunConfigurationModule)config.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            Module predefinedModule = ((JavaRunConfigurationModule)((TestNGConfiguration)RunManager.getInstance((Project)location.getProject()).getConfigurationTemplate(this.getConfigurationFactories()[0]).getConfiguration()).getConfigurationModule()).getModule();
            return Comparing.equal((Object)predefinedModule, (Object)configurationModule);
        }
        return false;
    }
}

