/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.android.vending.developer.signing.tools.extern.export;

import com.google.wireless.android.vending.developer.signing.tools.extern.export.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;

class KeystoreHelper {
    KeystoreHelper() {
    }

    PrivateKey getPrivateKey(String keystoreFileName, String alias, char[] keystorePass, char[] aliasKeyPass) throws GeneralSecurityException, IOException {
        KeyStore ks = this.loadKeystore(keystoreFileName, keystorePass);
        return this.extractPrivateKey(ks, alias, aliasKeyPass);
    }

    private KeyStore loadKeystore(String keystoreFileName, char[] storePass) throws GeneralSecurityException, IOException {
        if (storePass == null) {
            storePass = System.console().readPassword("Enter store password:", new Object[0]);
        }
        KeyStore keyStore = KeyStore.getInstance("jks");
        System.out.println(keystoreFileName);
        try (FileInputStream keyStoreIn = new FileInputStream(new File(keystoreFileName));){
            keyStore.load(keyStoreIn, storePass);
        }
        return keyStore;
    }

    private PrivateKey extractPrivateKey(KeyStore ks, String alias, char[] keyPass) throws GeneralSecurityException {
        if (keyPass == null) {
            keyPass = System.console().readPassword("Enter key password:", new Object[0]);
        }
        String string = String.valueOf(alias);
        return Utils.checkNotNull((PrivateKey)ks.getKey(alias, keyPass), string.length() != 0 ? "No key for alias: ".concat(string) : new String("No key for alias: "));
    }
}

