/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.template.GroovyTemplateContextType;

public class GroovyStructuralSearchProfile
extends StructuralSearchProfileBase {
    public static final String FILE_CONTEXT = "File";
    public static final String CLASS_CONTEXT = "Class";
    private static final TokenSet VARIABLE_DELIMETERS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mCOMMA, GroovyTokenTypes.mSEMI});

    @NotNull
    protected String[] getVarPrefixes() {
        return new String[]{"_$_____"};
    }

    @NotNull
    public String[] getContextNames() {
        return new String[]{FILE_CONTEXT, CLASS_CONTEXT};
    }

    @NotNull
    protected LanguageFileType getFileType() {
        return GroovyFileType.GROOVY_FILE_TYPE;
    }

    @NotNull
    protected TokenSet getVariableDelimiters() {
        return VARIABLE_DELIMETERS;
    }

    public PsiCodeFragment createCodeFragment(Project project, String text, @Nullable PsiElement context) {
        GroovyCodeFragment result2 = new GroovyCodeFragment(project, text);
        result2.setContext(context);
        return result2;
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return GroovyTemplateContextType.class;
    }

    public String getContext(@NotNull String pattern, @Nullable Language language, String contextName) {
        return CLASS_CONTEXT.equals(contextName) ? "class AAAAA { $$PATTERN_PLACEHOLDER$$ }" : "$$PATTERN_PLACEHOLDER$$";
    }

    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof PsiIdentifier;
    }
}

