/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.compiler.PatternClassBean;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.text.StringSearcher;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class PatternEditorContextMembersProvider
extends NonCodeMembersContributor {
    private static final Key<SoftFactoryMap<Class[], PsiFile>> PATTERN_INJECTION_CONTEXT = Key.create((String)"PATTERN_INJECTION_CONTEXT");
    private static final Key<CachedValue<Set<String>>> PATTERN_CLASSES = Key.create((String)"PATTERN_CLASSES");

    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor scopeProcessor, @NotNull PsiElement place, @NotNull ResolveState state) {
        PsiFile file = place.getContainingFile().getOriginalFile();
        BaseInjection injection = (BaseInjection)file.getUserData(BaseInjection.INJECTION_KEY);
        Processor processor = element -> element.processDeclarations(scopeProcessor, state, null, place);
        if (injection == null) {
            PatternEditorContextMembersProvider.processDevContext(file, (Processor<PsiElement>)processor);
        } else {
            PatternEditorContextMembersProvider.processPatternContext(injection, file, (Processor<PsiElement>)processor);
        }
    }

    private static boolean processPatternContext(@NotNull BaseInjection injection, @NotNull PsiFile file, @NotNull Processor<PsiElement> processor) {
        return processor.process((Object)PatternEditorContextMembersProvider.getRootByClasses(file, InjectorUtils.getPatternClasses((String)injection.getSupportId())));
    }

    @NotNull
    private static PsiFile getRootByClasses(@NotNull PsiFile file, @NotNull Class[] classes2) {
        final Project project = file.getProject();
        SoftFactoryMap map2 = (SoftFactoryMap)project.getUserData(PATTERN_INJECTION_CONTEXT);
        if (map2 == null) {
            map2 = new SoftFactoryMap<Class[], PsiFile>(){

                protected PsiFile create(Class[] key) {
                    String text = PatternCompilerFactory.getFactory().getPatternCompiler(key).dumpContextDeclarations();
                    return PsiFileFactory.getInstance((Project)project).createFileFromText("context.groovy", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)text);
                }
            };
            project.putUserData(PATTERN_INJECTION_CONTEXT, (Object)map2);
        }
        return (PsiFile)map2.get((Object)classes2);
    }

    private static boolean processDevContext(PsiFile file, Processor<PsiElement> processor) {
        String name;
        XmlTag tag = PatternEditorContextMembersProvider.getTagByInjectedFile(file);
        XmlTag parentTag = tag == null ? null : tag.getParentTag();
        String parentTagName = parentTag == null ? null : parentTag.getName();
        String string = name = tag == null ? null : tag.getName();
        if ("place".equals(name) && "injection".equals(parentTagName)) {
            return PatternEditorContextMembersProvider.processRootsByClassNames(file, parentTag.getAttributeValue("injector-id"), processor);
        }
        if ("pattern".equals(name) && parentTag != null) {
            return PatternEditorContextMembersProvider.processRootsByClassNames(file, tag.getAttributeValue("type"), processor);
        }
        return true;
    }

    @Nullable
    private static XmlTag getTagByInjectedFile(PsiFile file) {
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)file.getUserData(FileContextUtil.INJECTED_IN_ELEMENT);
        PsiElement element = pointer == null ? null : pointer.getElement();
        return element instanceof XmlText ? ((XmlText)element).getParentTag() : null;
    }

    private static boolean processRootsByClassNames(@NotNull PsiFile file, @Nullable String type2, @NotNull Processor<PsiElement> processor) {
        Project project = file.getProject();
        Set<String> classNames = PatternEditorContextMembersProvider.collectDevPatternClassNames(project);
        if (!classNames.isEmpty()) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            for (String className : classNames) {
                PsiClass patternClass = psiFacade.findClass(className, GlobalSearchScope.allScope((Project)project));
                if (patternClass == null || processor.process((Object)patternClass)) continue;
                return false;
            }
        }
        Class[] classes2 = StringUtil.isEmpty((String)type2) ? ArrayUtil.EMPTY_CLASS_ARRAY : PatternCompilerFactory.getFactory().getPatternClasses(type2);
        return classes2.length == 0 || processor.process((Object)PatternEditorContextMembersProvider.getRootByClasses(file, classes2));
    }

    private static Set<String> collectDevPatternClassNames(@NotNull Project project) {
        CachedValue cachedValue = (CachedValue)project.getUserData(PATTERN_CLASSES);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create(PatternEditorContextMembersProvider.calcDevPatternClassNames(project), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}), false);
            project.putUserData(PATTERN_CLASSES, (Object)cachedValue);
        }
        return (Set)cachedValue.getValue();
    }

    private static Set<String> calcDevPatternClassNames(@NotNull Project project) {
        List roots = ContainerUtil.createLockFreeCopyOnWriteList();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass beanClass = psiFacade.findClass(PatternClassBean.class.getName(), GlobalSearchScope.allScope((Project)project));
        if (beanClass != null) {
            GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.allScope((Project)project), (FileType[])new FileType[]{StdFileTypes.XML});
            TextOccurenceProcessor occurenceProcessor = (element, offsetInElement) -> {
                String className;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
                String string = className = tag == null ? null : tag.getAttributeValue("className");
                if (StringUtil.isNotEmpty((String)className) && tag.getLocalName().endsWith("patternClass")) {
                    roots.add(className);
                }
                return true;
            };
            StringSearcher searcher = new StringSearcher("patternClass", true, true);
            CacheManager.SERVICE.getInstance((Project)beanClass.getProject()).processFilesWithWord(psiFile -> {
                LowLevelSearchUtil.processElementsContainingWordInElement((TextOccurenceProcessor)occurenceProcessor, (PsiElement)psiFile, (StringSearcher)searcher, (boolean)true, (ProgressIndicator)new EmptyProgressIndicator());
                return true;
            }, searcher.getPattern(), (short)8, scope, searcher.isCaseSensitive());
        }
        return ContainerUtil.newHashSet((Iterable)roots);
    }
}

