/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class NewGroovyActionBase
extends CreateElementActionBase {
    @NonNls
    public static final String GROOVY_EXTENSION = ".groovy";

    public NewGroovyActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected final PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        Messages.showInputDialog((Project)project, (String)this.getDialogPrompt(), (String)this.getDialogTitle(), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        return validator.getCreatedElements();
    }

    protected abstract String getDialogPrompt();

    protected abstract String getDialogTitle();

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return GroovyFacetUtil.isSuitableModule(module) && LibrariesUtil.hasGroovySdk(module);
    }

    @NotNull
    protected PsiElement[] create(@NotNull String newName, PsiDirectory directory) throws Exception {
        return this.doCreate(newName, directory);
    }

    @NotNull
    protected abstract PsiElement[] doCreate(String var1, PsiDirectory var2) throws Exception;

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }
}

