/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighter;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GrReferenceHighlighterFactory
implements TextEditorHighlightingPassFactory {
    public GrReferenceHighlighterFactory(TextEditorHighlightingPassRegistrar registrar2) {
        registrar2.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiFile groovyFile = file.getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE);
        return groovyFile instanceof GroovyFileBase ? new GrReferenceHighlighter(editor.getDocument(), (GroovyFileBase)groovyFile) : null;
    }

    static boolean shouldHighlight(@NotNull PsiFile file) {
        return file instanceof GroovyFileBase && GrReferenceHighlighterFactory.shouldHighlight((GroovyFileBase)file);
    }

    static boolean shouldHighlight(@NotNull GroovyFileBase file) {
        return GrReferenceHighlighterFactory.isSpecificScriptFile(file) || GrFileIndexUtil.isGroovySourceFile(file);
    }

    private static boolean isSpecificScriptFile(@NotNull GroovyFileBase file) {
        return file instanceof GroovyFile && GroovyScriptTypeDetector.isScriptFile((GroovyFile)file);
    }
}

