/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.AnnotationFixRegistrar;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighterFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.ReferenceFixesKt;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u00a8\u0006\u000b"}, d2={"checkInnerClassReferenceFromInstanceContext", "", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "checkUnresolvedCodeReference", "annotationHolder", "isResolvedStaticImport", "", "refElement", "intellij.groovy.psi"})
public final class ImplKt {
    public static final void checkUnresolvedCodeReference(@NotNull GrCodeReferenceElement ref, @NotNull AnnotationHolder annotationHolder) {
        IntentionAction p1;
        if (!GrReferenceHighlighterFactory.shouldHighlight(annotationHolder.getCurrentAnnotationSession().getFile())) {
            return;
        }
        PsiElement $receiver$iv = ref;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(GroovyDocPsiElement.class)}) != null) {
            return;
        }
        if (ref.getParent() instanceof GrPackageDefinition) {
            return;
        }
        PsiElement psiElement = ref.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        PsiElement nameElement = psiElement;
        String string = ref.getReferenceName();
        if (string == null) {
            return;
        }
        String referenceName = string;
        if (ImplKt.isResolvedStaticImport(ref)) {
            return;
        }
        if (ref.resolve() != null) {
            return;
        }
        Annotation annotation = annotationHolder.createErrorAnnotation(nameElement, GroovyBundle.message("cannot.resolve", referenceName));
        annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        Iterable $receiver$iv2 = ReferenceFixesKt.generateCreateClassActions(ref);
        for (Object element$iv : $receiver$iv2) {
            p1 = (IntentionAction)element$iv;
            boolean bl = false;
            annotation.registerFix(p1);
        }
        $receiver$iv2 = ReferenceFixesKt.generateAddImportActions(ref);
        for (Object element$iv : $receiver$iv2) {
            p1 = (IntentionAction)element$iv;
            boolean bl = false;
            annotation.registerFix(p1);
        }
        AnnotationFixRegistrar fixRegistrar = new AnnotationFixRegistrar(annotation);
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)((PsiReference)ref), (QuickFixActionRegistrar)fixRegistrar);
        QuickFixFactory.getInstance().registerOrderEntryFixes((QuickFixActionRegistrar)fixRegistrar, (PsiReference)ref);
    }

    private static final boolean isResolvedStaticImport(GrCodeReferenceElement refElement) {
        GroovyResolveResult[] groovyResolveResultArray;
        GroovyResolveResult[] groovyResolveResultArray2;
        PsiElement parent2 = refElement.getParent();
        return parent2 instanceof GrImportStatement && ((GrImportStatement)parent2).isStatic() && !((groovyResolveResultArray2 = (groovyResolveResultArray = refElement.multiResolve(false))).length == 0);
    }

    public static final void checkInnerClassReferenceFromInstanceContext(@NotNull GrCodeReferenceElement ref, @NotNull AnnotationHolder holder) {
        PsiElement psiElement = ref.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        PsiElement nameElement = psiElement;
        PsiElement parent2 = ref.getParent();
        if (!(parent2 instanceof GrNewExpression) || PsiImplUtil.hasArguments((GrCall)parent2)) {
            return;
        }
        if (!GrStaticChecker.isInStaticContext(ref)) {
            return;
        }
        PsiElement psiElement2 = ref.resolve();
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        PsiClass psiClass = (PsiClass)psiElement2;
        if (psiClass == null) {
            return;
        }
        PsiClass resolved = psiClass;
        if (!com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)resolved)) {
            return;
        }
        String string = resolved.getQualifiedName();
        if (string == null) {
            return;
        }
        String qname = string;
        PsiClass psiClass2 = resolved.getContainingClass();
        if (psiClass2 == null) {
            return;
        }
        PsiClass outerClass = psiClass2;
        if (PsiUtil.hasEnclosingInstanceInScope(outerClass, parent2, true)) {
            return;
        }
        holder.createErrorAnnotation(nameElement, GroovyBundle.message("cannot.reference.non.static", qname));
    }
}

