/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrRemoveAnnotationIntention;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class AnnotationChecker {
    private final AnnotationHolder myHolder;

    public AnnotationChecker(@NotNull AnnotationHolder holder) {
        this.myHolder = holder;
    }

    public void checkApplicability(@NotNull GrAnnotation annotation, @Nullable PsiAnnotationOwner owner) {
        GrCodeReferenceElement ref = annotation.getClassReference();
        PsiElement resolved = ref.resolve();
        if (resolved == null) {
            return;
        }
        assert (resolved instanceof PsiClass);
        PsiClass anno = (PsiClass)resolved;
        String qname = anno.getQualifiedName();
        if (!anno.isAnnotationType() && GrAnnotationCollector.findAnnotationCollector(anno) == null) {
            if (qname != null) {
                this.myHolder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("class.is.not.annotation", qname));
            }
            return;
        }
        for (CustomAnnotationChecker checker : (CustomAnnotationChecker[])CustomAnnotationChecker.EP_NAME.getExtensions()) {
            if (!checker.checkApplicability(this.myHolder, annotation)) continue;
            return;
        }
        String description = CustomAnnotationChecker.isAnnotationApplicable(annotation, owner);
        if (description != null) {
            this.myHolder.createErrorAnnotation((PsiElement)ref, description).registerFix((IntentionAction)new GrRemoveAnnotationIntention());
        }
    }

    public boolean checkAnnotationArgumentList(@NotNull GrAnnotation annotation) {
        PsiClass anno = ResolveUtil.resolveAnnotation(annotation);
        if (anno == null) {
            return false;
        }
        for (CustomAnnotationChecker checker : (CustomAnnotationChecker[])CustomAnnotationChecker.EP_NAME.getExtensions()) {
            if (!checker.checkArgumentList(this.myHolder, annotation)) continue;
            return true;
        }
        return CustomAnnotationChecker.checkAnnotationArguments(this.myHolder, anno, annotation.getClassReference(), annotation.getParameterList().getAttributes(), true);
    }
}

