/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class BaseScriptAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if ("groovy.transform.BaseScript".equals(annotation.getQualifiedName())) {
            PsiFile file = annotation.getContainingFile();
            if (file instanceof GroovyFile && !((GroovyFile)file).isScript()) {
                holder.createErrorAnnotation((PsiElement)annotation, GroovyBundle.message("base.script.annotation.is.allowed.only.inside.scripts", new Object[0]));
                return true;
            }
            PsiElement pparent = annotation.getParent().getParent();
            if (pparent instanceof GrVariableDeclaration) {
                PsiType type2;
                GrTypeElement typeElement = ((GrVariableDeclaration)pparent).getTypeElementGroovy();
                PsiType psiType = type2 = typeElement != null ? typeElement.getType() : null;
                if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"groovy.lang.Script")) {
                    String typeText = type2 != null ? type2.getCanonicalText() : "java.lang.Object";
                    holder.createErrorAnnotation((PsiElement)annotation, GroovyBundle.message("declared.type.0.have.to.extend.script", typeText));
                    return true;
                }
            }
        }
        return false;
    }
}

