/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class DelegateAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiElement owner;
        if (!"groovy.lang.Delegate".equals(annotation.getQualifiedName())) {
            return false;
        }
        PsiElement annoParent = annotation.getParent();
        PsiElement psiElement = owner = annoParent instanceof PsiModifierList ? annoParent.getParent() : annoParent;
        if (!(owner instanceof GrMethod)) {
            return false;
        }
        if (((GrMethod)owner).getParameterList().getParametersCount() > 0) {
            holder.createErrorAnnotation((PsiElement)annotation, GroovyBundle.message("delegate.annotation.is.only.for.methods.without.arguments", new Object[0]));
            return true;
        }
        return false;
    }
}

