/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.intentions.GrCreateFromUsageBaseFix;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class CreateMethodFromUsageFix
extends GrCreateFromUsageBaseFix
implements IntentionAction {
    public CreateMethodFromUsageFix(@NotNull GrReferenceExpression refExpression) {
        super(refExpression);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("create.method.from.usage.family.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        return GroovyBundle.message("create.method.from.usage", this.getMethodName());
    }

    @Override
    protected void invokeImpl(Project project, @NotNull PsiClass targetClass) {
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        assert (factory != null);
        PsiMethod method = factory.createMethod(this.getMethodName(), (PsiType)PsiType.VOID);
        GrReferenceExpression ref = this.getRefExpr();
        if (GrStaticChecker.isInStaticContext(ref, targetClass)) {
            method.getModifierList().setModifierProperty("static", true);
        }
        PsiType[] argTypes = this.getArgumentTypes();
        assert (argTypes != null);
        ChooseTypeExpression[] paramTypesExpressions = this.setupParams(method, argTypes, factory);
        TypeConstraint[] constraints = this.getReturnTypeConstraints();
        PsiGenerationInfo info = OverrideImplementUtil.createGenerationInfo((PsiMethod)method);
        info.insert(targetClass, this.findInsertionAnchor((PsiGenerationInfo<PsiMethod>)info, targetClass), false);
        method = (PsiMethod)info.getPsiMember();
        if (this.shouldBeAbstract(targetClass)) {
            method.getBody().delete();
            if (!targetClass.isInterface()) {
                method.getModifierList().setModifierProperty("abstract", true);
            }
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class, PsiMethod.class, PsiFile.class});
        IntentionUtils.createTemplateForMethod(paramTypesExpressions, method, targetClass, constraints, false, context);
    }

    @NotNull
    protected TypeConstraint[] getReturnTypeConstraints() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints((GrExpression)this.getRefExpr().getParent());
    }

    protected PsiType[] getArgumentTypes() {
        return PsiUtil.getArgumentTypes(this.getRefExpr(), false);
    }

    @NotNull
    protected String getMethodName() {
        return this.getRefExpr().getReferenceName();
    }

    protected boolean shouldBeAbstract(PsiClass aClass) {
        return aClass.isInterface() && !GrTraitUtil.isTrait(aClass);
    }

    @Nullable
    private PsiElement findInsertionAnchor(PsiGenerationInfo<PsiMethod> info, PsiClass targetClass) {
        PsiClass parent2;
        Object object = parent2 = targetClass instanceof GroovyScriptClass ? ((GroovyScriptClass)targetClass).getContainingFile() : targetClass;
        if (PsiTreeUtil.isAncestor((PsiElement)parent2, (PsiElement)this.getRefExpr(), (boolean)false)) {
            return info.findInsertionAnchor(targetClass, (PsiElement)this.getRefExpr());
        }
        return null;
    }

    @NotNull
    private ChooseTypeExpression[] setupParams(@NotNull PsiMethod method, @NotNull PsiType[] argTypes, @NotNull JVMElementFactory factory) {
        PsiParameterList parameterList = method.getParameterList();
        ChooseTypeExpression[] paramTypesExpressions = new ChooseTypeExpression[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType argType = TypesUtil.unboxPrimitiveTypeWrapper(argTypes[i]);
            if (argType == null || argType == PsiType.NULL) {
                argType = TypesUtil.getJavaLangObject(this.getRefExpr());
            }
            PsiParameter p = factory.createParameter("o", argType);
            parameterList.add((PsiElement)p);
            TypeConstraint[] constraints = new TypeConstraint[]{SupertypeConstraint.create(argType)};
            boolean isGroovy = method.getLanguage() == GroovyLanguage.INSTANCE;
            paramTypesExpressions[i] = new ChooseTypeExpression(constraints, method.getManager(), method.getResolveScope(), isGroovy);
        }
        return paramTypesExpressions;
    }
}

