/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public abstract class GrCreateFromUsageBaseFix
extends Intention {
    protected final SmartPsiElementPointer<GrReferenceExpression> myRefExpression;

    public GrCreateFromUsageBaseFix(@NotNull GrReferenceExpression refExpression) {
        this.myRefExpression = SmartPointerManager.getInstance((Project)refExpression.getProject()).createSmartPsiElementPointer((PsiElement)refExpression);
    }

    protected GrReferenceExpression getRefExpr() {
        return (GrReferenceExpression)this.myRefExpression.getElement();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        GrReferenceExpression element = (GrReferenceExpression)this.myRefExpression.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        List<PsiClass> targetClasses = this.getTargetClasses();
        return !targetClasses.isEmpty();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        List<PsiClass> classes2 = this.getTargetClasses();
        if (classes2.size() == 1) {
            this.invokeImpl(project, classes2.get(0));
        } else if (!classes2.isEmpty()) {
            this.chooseClass(classes2, editor);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                return element instanceof GrReferenceExpression;
            }
        };
    }

    private void chooseClass(List<PsiClass> classes2, Editor editor) {
        Project project = classes2.get(0).getProject();
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(classes2).setRenderer((ListCellRenderer)renderer).setSelectionMode(0).setItemChosenCallback(aClass -> CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> this.invokeImpl(project, (PsiClass)aClass)), this.getText(), null)).setTitle(QuickFixBundle.message((String)"target.class.chooser.title", (Object[])new Object[0]));
        renderer.installSpeedSearch(builder);
        builder.createPopup().showInBestPositionFor(editor);
    }

    protected abstract void invokeImpl(Project var1, @NotNull PsiClass var2);

    private List<PsiClass> getTargetClasses() {
        GrReferenceExpression ref = this.getRefExpr();
        PsiClass targetClass = QuickfixUtil.findTargetClass(ref);
        if (targetClass == null || !this.canBeTargetClass(targetClass)) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
        this.collectSupers(targetClass, classes2);
        return classes2;
    }

    private void collectSupers(PsiClass psiClass, ArrayList<PsiClass> classes2) {
        PsiClass[] supers;
        classes2.add(psiClass);
        for (PsiClass aSuper : supers = psiClass.getSupers()) {
            if (classes2.contains(aSuper) || !this.canBeTargetClass(aSuper)) continue;
            this.collectSupers(aSuper, classes2);
        }
    }

    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass);
    }
}

