/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GrMoveToDirFix
extends GroovyFix {
    private final String myPackageName;

    public GrMoveToDirFix(String packageName) {
        this.myPackageName = packageName;
    }

    @NotNull
    public String getName() {
        String packName = StringUtil.isEmptyOrSpaces((String)this.myPackageName) ? "default package" : this.myPackageName;
        return GroovyIntentionsBundle.message("move.to.correct.dir", packName);
    }

    @NotNull
    public String getFamilyName() {
        return GroovyIntentionsBundle.message("move.to.correct.dir.family.name", new Object[0]);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiFile file = descriptor2.getPsiElement().getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return;
        }
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vfile, (Project)project);
        if (module == null) {
            return;
        }
        String packageName = ((GroovyFile)file).getPackageName();
        PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)packageName, null, (boolean)true);
        if (directory == null) {
            return;
        }
        String error = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)directory, (String)file.getName());
        if (error != null) {
            Messages.showMessageDialog((Project)project, (String)error, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{file}, directory, false, false, false, null, null).run();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

