/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrReplacePrimitiveTypeWithWrapperFix
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance(GrReplacePrimitiveTypeWithWrapperFix.class);
    private final String myBoxedName;

    public GrReplacePrimitiveTypeWithWrapperFix(GrTypeElement typeElement) {
        LOG.assertTrue(typeElement.isValid());
        PsiType type2 = typeElement.getType();
        LOG.assertTrue(type2 instanceof PsiPrimitiveType);
        this.myBoxedName = ((PsiPrimitiveType)type2).getBoxedTypeName();
    }

    @NotNull
    public String getName() {
        return GroovyIntentionsBundle.message("replace.with.wrapper", this.myBoxedName);
    }

    @NotNull
    public String getFamilyName() {
        return GroovyIntentionsBundle.message("replace.primitive.type.with.wrapper", new Object[0]);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiElement element = descriptor2.getPsiElement();
        assert (element instanceof GrTypeElement) : element;
        GrTypeElement typeElement = (GrTypeElement)element;
        PsiType type2 = typeElement.getType();
        if (!(type2 instanceof PsiPrimitiveType)) {
            return;
        }
        PsiClassType boxed = ((PsiPrimitiveType)type2).getBoxedType((PsiElement)typeElement);
        if (boxed == null) {
            return;
        }
        GrTypeElement newTypeElement = GroovyPsiElementFactory.getInstance(project).createTypeElement((PsiType)boxed);
        PsiElement replaced = typeElement.replace(newTypeElement);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
    }
}

