/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GroovyAddImportAction
extends ImportClassFixBase<GrReferenceElement, GrReferenceElement> {
    public GroovyAddImportAction(@NotNull GrReferenceElement ref) {
        super((PsiElement)ref, (PsiReference)ref);
    }

    protected String getReferenceName(@NotNull GrReferenceElement reference) {
        return reference.getReferenceName();
    }

    protected PsiElement getReferenceNameElement(@NotNull GrReferenceElement reference) {
        return reference.getReferenceNameElement();
    }

    protected boolean hasTypeParameters(@NotNull GrReferenceElement reference) {
        return reference.getTypeArguments().length > 0;
    }

    protected String getQualifiedName(GrReferenceElement reference) {
        return reference.getCanonicalText();
    }

    protected boolean isQualified(GrReferenceElement reference) {
        return reference.getQualifier() != null;
    }

    protected boolean hasUnresolvedImportWhichCanImport(PsiFile psiFile, String name) {
        GrImportStatement[] importStatements;
        if (!(psiFile instanceof GroovyFile)) {
            return false;
        }
        for (GrImportStatement importStatement : importStatements = ((GroovyFile)psiFile).getImportStatements()) {
            GrCodeReferenceElement importReference = importStatement.getImportReference();
            if (importReference == null || importReference.resolve() != null || !importStatement.isOnDemand() && !Comparing.strEqual((String)importStatement.getImportedName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull GrReferenceElement ref) {
        PsiElement typeElement = ref.getParent();
        if (typeElement instanceof GrTypeElement) {
            PsiExpression initializer;
            GrVariable[] vars;
            PsiElement decl = typeElement.getParent();
            if (decl instanceof GrVariableDeclaration && (vars = ((GrVariableDeclaration)decl).getVariables()).length == 1 && (initializer = vars[0].getInitializer()) != null) {
                return GroovyAddImportAction.filterAssignableFrom((PsiType)initializer.getType(), candidates);
            }
            if (decl instanceof GrParameter) {
                return GroovyAddImportAction.filterBySuperMethods((PsiParameter)((PsiParameter)decl), candidates);
            }
        }
        return super.filterByContext(candidates, (PsiElement)ref);
    }

    protected String getRequiredMemberName(GrReferenceElement reference) {
        if (reference.getParent() instanceof GrReferenceElement) {
            return ((GrReferenceElement)reference.getParent()).getReferenceName();
        }
        return super.getRequiredMemberName((PsiElement)reference);
    }

    protected boolean isAccessible(PsiMember member, GrReferenceElement reference) {
        return true;
    }
}

