/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;

public class GroovyCreateClassDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private JLabel myInformationLabel;
    private EditorTextField myPackageTextField;
    private JButton myPackageChooseButton;
    private PsiDirectory myTargetDirectory;
    private final Project myProject;
    private final String myClassName;
    private final Module myModule;

    public GroovyCreateClassDialog(Project project, String title, String targetClassName, String targetPackageName, Module module) {
        super(project, true);
        this.myClassName = targetClassName;
        this.myProject = project;
        this.myModule = module;
        this.$$$setupUI$$$();
        this.setModal(true);
        this.setTitle(title);
        this.myInformationLabel.setText(title);
        this.myPackageTextField.setText(targetPackageName != null ? targetPackageName : "");
        this.init();
        this.myPackageChooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PackageChooserDialog chooser = new PackageChooserDialog(GroovyInspectionBundle.message("dialog.create.class.package.chooser.title", new Object[0]), GroovyCreateClassDialog.this.myProject);
                chooser.selectPackage(GroovyCreateClassDialog.this.myPackageTextField.getText());
                chooser.show();
                PsiPackage aPackage = chooser.getSelectedPackage();
                if (aPackage != null) {
                    GroovyCreateClassDialog.this.myPackageTextField.setText(aPackage.getQualifiedName());
                }
            }
        });
    }

    private void createUIComponents() {
        this.myPackageTextField = new EditorTextField();
        this.myPackageChooseButton = new FixedSizeButton((JComponent)this.myPackageTextField);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPackageTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)GroovyCreateClassDialog.this.myProject);
                String packageName = GroovyCreateClassDialog.this.getPackageName();
                GroovyCreateClassDialog.this.getOKAction().setEnabled(nameHelper.isQualifiedName(packageName) || packageName != null && packageName.isEmpty());
            }
        });
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                GroovyCreateClassDialog.this.myPackageChooseButton.doClick();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), (JComponent)this.myPackageTextField);
        return this.myContentPane;
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPackageTextField;
    }

    private String getPackageName() {
        String name = this.myPackageTextField.getText();
        return name != null ? name.trim() : "";
    }

    protected void doOKAction() {
        String packageName = this.getPackageName();
        Ref errorStringRef = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                PsiDirectory baseDir = this.myModule == null ? null : PackageUtil.findPossiblePackageDirectoryInModule((Module)this.myModule, (String)packageName);
                PsiDirectory psiDirectory = this.myTargetDirectory = this.myModule == null ? null : PackageUtil.findOrCreateDirectoryForPackage((Module)this.myModule, (String)packageName, (PsiDirectory)baseDir, (boolean)true);
                if (this.myTargetDirectory == null) {
                    errorStringRef.set((Object)"");
                    return;
                }
                errorStringRef.set((Object)RefactoringMessageUtil.checkCanCreateClass((PsiDirectory)this.myTargetDirectory, (String)this.getClassName()));
            }
            catch (IncorrectOperationException e) {
                errorStringRef.set((Object)e.getMessage());
            }
        }, GroovyInspectionBundle.message("create.directory.command", new Object[0]), null);
        if (errorStringRef.get() != null) {
            if (!((String)errorStringRef.get()).isEmpty()) {
                Messages.showMessageDialog((Project)this.myProject, (String)((String)errorStringRef.get()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
            return;
        }
        super.doOKAction();
    }

    public String getClassName() {
        return this.myClassName;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/codeInspection/GroovyInspectionBundle").getString("destination.package"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myPackageTextField;
        jPanel3.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myInformationLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JButton jButton = this.myPackageChooseButton;
        jButton.setText("");
        jPanel3.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

