/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStaticImportMethodFix
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.annotator.intentions.GroovyStaticImportMethodFix");
    private final SmartPsiElementPointer<GrMethodCall> myMethodCall;
    private List<PsiMethod> myCandidates = null;

    public GroovyStaticImportMethodFix(@NotNull GrMethodCall methodCallExpression) {
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @Override
    @NotNull
    public String getText() {
        String text = "Static import method";
        if (this.getCandidates().size() == 1) {
            int options = 6145;
            text = text + " '" + PsiFormatUtil.formatMethod((PsiMethod)this.getCandidates().get(0), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0) + "'";
        } else {
            text = text + "...";
        }
        return text;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Nullable
    private GrReferenceExpression getMethodExpression() {
        GrMethodCall methodCall = (GrMethodCall)this.myMethodCall.getElement();
        if (methodCall == null) {
            return null;
        }
        return GroovyStaticImportMethodFix.getMethodExpression(methodCall);
    }

    @Nullable
    private static GrReferenceExpression getMethodExpression(@NotNull GrMethodCall call) {
        GrExpression result2 = call.getInvokedExpression();
        return result2 instanceof GrReferenceExpression ? (GrReferenceExpression)result2 : null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        this.myCandidates = null;
        if (!file.getManager().isInProject((PsiElement)file)) {
            return false;
        }
        GrReferenceExpression invokedExpression = this.getMethodExpression();
        if (invokedExpression == null || invokedExpression.getQualifierExpression() != null) {
            return false;
        }
        return !this.getCandidates().isEmpty();
    }

    @NotNull
    private List<PsiMethod> getMethodsToImport() {
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)this.myMethodCall.getProject());
        GrMethodCall element = (GrMethodCall)this.myMethodCall.getElement();
        LOG.assertTrue(element != null);
        GrReferenceExpression reference = GroovyStaticImportMethodFix.getMethodExpression(element);
        LOG.assertTrue(reference != null);
        GrArgumentList argumentList = element.getArgumentList();
        String name = reference.getReferenceName();
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        if (name == null) {
            return list;
        }
        GlobalSearchScope scope = element.getResolveScope();
        PsiMethod[] methods = cache2.getMethodsByNameIfNotMoreThan(name, scope, 20);
        ArrayList<PsiMethod> applicableList = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            PsiFile file;
            ProgressManager.checkCanceled();
            if (JavaCompletionUtil.isInExcludedPackage((PsiMember)method, (boolean)false) || !method.hasModifierProperty("static") || !((file = method.getContainingFile()) instanceof PsiClassOwner) || ((PsiClassOwner)file).getPackageName().isEmpty() || !PsiUtil.isAccessible(element, (PsiMember)method)) continue;
            list.add(method);
            if (!PsiUtil.isApplicable(PsiUtil.getArgumentTypes(element, true), method, PsiSubstitutor.EMPTY, element, false)) continue;
            applicableList.add(method);
        }
        ArrayList<PsiMethod> result2 = applicableList.isEmpty() ? list : applicableList;
        Collections.sort(result2, new PsiProximityComparator((PsiElement)argumentList));
        return result2;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (this.getCandidates().size() == 1) {
            PsiMethod toImport = this.getCandidates().get(0);
            this.doImport(toImport);
        } else {
            this.chooseAndImport(editor);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                return true;
            }
        };
    }

    private void doImport(PsiMethod toImport) {
        CommandProcessor.getInstance().executeCommand(toImport.getProject(), () -> WriteAction.run(() -> {
            try {
                GrReferenceExpression expression = this.getMethodExpression();
                if (expression != null) {
                    expression.bindToElementViaStaticImport((PsiMember)toImport);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), this.getText(), (Object)this);
    }

    private void chooseAndImport(Editor editor) {
        JBPopupFactory.getInstance().createPopupChooserBuilder(this.getCandidates()).setRenderer((ListCellRenderer)new MethodCellRenderer(true)).setTitle(QuickFixBundle.message((String)"static.import.method.choose.method.to.import", (Object[])new Object[0])).setMovable(true).setItemChosenCallback(selectedValue -> {
            LOG.assertTrue(selectedValue.isValid());
            this.doImport((PsiMethod)selectedValue);
        }).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    private List<PsiMethod> getCandidates() {
        List<PsiMethod> result2 = this.myCandidates;
        if (result2 == null) {
            this.myCandidates = result2 = this.getMethodsToImport();
        }
        return result2;
    }
}

