/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicPropertyFix;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicDialog;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicPropertyDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class DynamicPropertyFromRefFix
extends DynamicPropertyFix {
    private final SmartPsiElementPointer<GrReferenceExpression> myReferenceExpressionPointer;

    public DynamicPropertyFromRefFix(GrReferenceExpression referenceExpression) {
        this.myReferenceExpressionPointer = PointersKt.createSmartPointer((PsiElement)referenceExpression);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        GrReferenceExpression expression = (GrReferenceExpression)this.myReferenceExpressionPointer.getElement();
        return expression != null && !PsiUtil.isInStaticCompilationContext(expression);
    }

    @Override
    @Nullable
    protected String getRefName() {
        GrReferenceExpression referenceExpression = (GrReferenceExpression)this.myReferenceExpressionPointer.getElement();
        return referenceExpression == null ? null : referenceExpression.getReferenceName();
    }

    @Override
    @NotNull
    protected DynamicDialog createDialog() {
        return new DynamicPropertyDialog((GrReferenceExpression)this.myReferenceExpressionPointer.getElement());
    }

    @Override
    public void invoke(Project project) throws IncorrectOperationException {
        DynamicElementSettings settings = QuickfixUtil.createSettings((GrReferenceExpression)this.myReferenceExpressionPointer.getElement());
        DynamicManager.getInstance(project).addProperty(settings);
    }

    public GrReferenceExpression getReferenceExpression() {
        return (GrReferenceExpression)this.myReferenceExpressionPointer.getElement();
    }
}

