/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateEnumConstantActionKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a*\u0010\u0006\u001a\u00020\u00012\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0012"}, d2={"canCreateEnumConstant", "", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "checkExpectedTypes", "types", "", "Lcom/intellij/lang/jvm/actions/ExpectedType;", "Lcom/intellij/lang/jvm/actions/ExpectedTypes;", "project", "Lcom/intellij/openapi/project/Project;", "renderConstant", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrEnumConstant;", "text", "", "renderParameters", "intellij.groovy"})
public final class CreateEnumConstantActionKt {
    @NotNull
    public static final GrEnumConstant renderConstant(@NotNull Project project, @NotNull String text) {
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(project);
        return elementFactory.createEnumConstantFromText(text);
    }

    @NotNull
    public static final String renderParameters(@NotNull GrTypeDefinition targetClass) {
        PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])targetClass.getConstructors());
        if (psiMethod == null) {
            return "";
        }
        PsiMethod constructor = psiMethod;
        Object[] parameters = constructor.getParameterList().getParameters();
        return ArraysKt.joinToString$default((Object[])parameters, (CharSequence)",", null, null, (int)0, null, (Function1)renderParameters.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canCreateEnumConstant(@NotNull GrTypeDefinition targetClass, @NotNull CreateFieldRequest request) {
        void $receiver$iv$iv;
        GrField[] $receiver$iv;
        if (!targetClass.isEnum()) {
            return false;
        }
        GrField[] grFieldArray = $receiver$iv = targetClass.getFields();
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof GrEnumConstant)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GrEnumConstant lastConstant = (GrEnumConstant)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
        if (lastConstant != null && PsiTreeUtil.hasErrorElements((PsiElement)lastConstant)) {
            return false;
        }
        return CreateEnumConstantActionKt.checkExpectedTypes(request.getFieldType(), targetClass, targetClass.getProject());
    }

    private static final boolean checkExpectedTypes(List<? extends ExpectedType> types, GrTypeDefinition targetClass, Project project) {
        boolean bl;
        block4: {
            List<TypeConstraint> constraints = JvmPsiUtilKt.createConstraints(project, types);
            if (constraints.isEmpty()) {
                return true;
            }
            PsiClassType enumType = GroovyPsiElementFactory.getInstance(project).createType(targetClass);
            Iterable $receiver$iv = constraints;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeConstraint it = (TypeConstraint)element$iv;
                    boolean bl2 = false;
                    if (!it.satisfied((PsiType)enumType, targetClass)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

