/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.lang.jvm.actions.ExpectedTypesKt;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt$WhenMappings;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\fH\u0000\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0002H\u0001\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004*\u0018\b\u0000\u0010\u001b\"\b\u0012\u0004\u0012\u00020\u001c0\u00062\b\u0012\u0004\u0012\u00020\u001c0\u0006\u00a8\u0006\u001d"}, d2={"visibilityModifiers", "", "Lcom/intellij/lang/jvm/JvmModifier;", "getVisibilityModifiers", "()Ljava/util/Set;", "createConstraints", "", "Lorg/jetbrains/plugins/groovy/lang/psi/expectedTypes/TypeConstraint;", "project", "Lcom/intellij/openapi/project/Project;", "expectedTypes", "Lcom/intellij/lang/jvm/actions/ExpectedType;", "Lcom/intellij/lang/jvm/actions/ExpectedTypes;", "toTypeConstraint", "expectedType", "createPropertyTypeConstraints", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "kind", "Lcom/intellij/lang/java/beans/PropertyKind;", "toGroovyClassOrNull", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "Lcom/intellij/lang/jvm/JvmClass;", "toPsiModifier", "", "toPsiSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "Lcom/intellij/lang/jvm/types/JvmSubstitutor;", "ExpectedParameters", "Lcom/intellij/lang/jvm/actions/ExpectedParameter;", "intellij.groovy"})
public final class JvmPsiUtilKt {
    @NotNull
    private static final Set<JvmModifier> visibilityModifiers = SetsKt.setOf((Object[])new JvmModifier[]{JvmModifier.PUBLIC, JvmModifier.PROTECTED, JvmModifier.PACKAGE_LOCAL, JvmModifier.PRIVATE});

    @PsiModifier.ModifierConstant
    @NotNull
    public static final String toPsiModifier(@NotNull JvmModifier $receiver) {
        String string;
        switch (JvmPsiUtilKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                string = "public";
                break;
            }
            case 2: {
                string = "protected";
                break;
            }
            case 3: {
                string = "private";
                break;
            }
            case 4: {
                string = "packageLocal";
                break;
            }
            case 5: {
                string = "static";
                break;
            }
            case 6: {
                string = "abstract";
                break;
            }
            case 7: {
                string = "final";
                break;
            }
            case 8: {
                string = "native";
                break;
            }
            case 9: {
                string = "native";
                break;
            }
            case 10: {
                string = "strictfp";
                break;
            }
            case 11: {
                string = "transient";
                break;
            }
            case 12: {
                string = "volatile";
                break;
            }
            case 13: {
                string = "transitive";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Nullable
    public static final GrTypeDefinition toGroovyClassOrNull(@NotNull JvmClass $receiver) {
        if (!($receiver instanceof GrTypeDefinition)) {
            return null;
        }
        if ($receiver instanceof PsiTypeParameter) {
            return null;
        }
        if ($receiver instanceof ClsClassImpl) {
            return null;
        }
        if ($receiver instanceof GroovyScriptClass) {
            return (GrTypeDefinition)$receiver;
        }
        if ($receiver instanceof LightElement) {
            return null;
        }
        return (GrTypeDefinition)$receiver;
    }

    @NotNull
    public static final Set<JvmModifier> getVisibilityModifiers() {
        return visibilityModifiers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeConstraint> createConstraints(@NotNull Project project, @NotNull List<? extends ExpectedType> expectedTypes2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)expectedTypes2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeConstraint typeConstraint;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            ExpectedType it = (ExpectedType)element$iv$iv;
            boolean bl = false;
            if (JvmPsiUtilKt.toTypeConstraint(project, it) == null) continue;
            TypeConstraint it$iv$iv = typeConstraint;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final TypeConstraint toTypeConstraint(Project project, ExpectedType expectedType) {
        JvmPsiConversionHelper helper = JvmPsiConversionHelper.getInstance((Project)project);
        PsiType psiType = helper.convertType(expectedType.getTheType());
        return expectedType.getTheKind() == ExpectedType.Kind.SUPERTYPE ? (TypeConstraint)SupertypeConstraint.create(psiType) : (TypeConstraint)SubtypeConstraint.create(psiType);
    }

    @NotNull
    public static final PsiSubstitutor toPsiSubstitutor(@NotNull JvmSubstitutor $receiver, @NotNull Project project) {
        return JvmPsiConversionHelper.getInstance((Project)project).convertSubstitutor($receiver);
    }

    @NotNull
    public static final List<ExpectedType> createPropertyTypeConstraints(@NotNull CreateMethodRequest $receiver, @NotNull PropertyKind kind) {
        List list;
        switch (JvmPsiUtilKt$WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
            case 1: {
                list = $receiver.getReturnType();
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)ExpectedTypesKt.expectedType$default((JvmType)((JvmType)PsiType.BOOLEAN), null, (int)2, null));
                break;
            }
            case 3: {
                list = ((ExpectedParameter)CollectionsKt.single((List)$receiver.getExpectedParameters())).getExpectedTypes();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }
}

