/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.byteCodeViewer;

import com.intellij.byteCodeViewer.ClassSearcher;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyScriptClassSearcher
implements ClassSearcher {
    @Nullable
    public PsiClass findClass(@NotNull PsiElement place) {
        if (place.getLanguage() == GroovyLanguage.INSTANCE) {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)false);
            while (containingClass instanceof PsiTypeParameter) {
                containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
            }
            if (containingClass != null) {
                return containingClass;
            }
            PsiFile file = place.getContainingFile();
            if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
                return ((GroovyFile)file).getScriptClass();
            }
        }
        return null;
    }
}

