/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GroovyGotoSuperHandler
extends GotoTargetHandler
implements LanguageCodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GroovyGotoSuperHandler.class);

    protected String getFeatureUsedKey() {
        return "navigation.goto.super";
    }

    protected GotoTargetHandler.GotoData getSourceAndTargetElements(Editor editor, PsiFile file) {
        PsiMember e = GroovyGotoSuperHandler.findSource(editor, file);
        if (e == null) {
            return null;
        }
        return new GotoTargetHandler.GotoData((PsiElement)e, GroovyGotoSuperHandler.findTargets(e), Collections.emptyList());
    }

    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished) {
        return CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]);
    }

    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        return CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{name});
    }

    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiMember source = GroovyGotoSuperHandler.findSource(editor, file);
        if (source instanceof PsiClass) {
            return GroovyBundle.message("no.super.classes.found", new Object[0]);
        }
        if (source instanceof PsiMethod || source instanceof GrField) {
            return GroovyBundle.message("no.super.method.found", new Object[0]);
        }
        throw new IncorrectOperationException("incorrect element is found: " + (source == null ? "null" : source.getClass().getCanonicalName()));
    }

    @Nullable
    private static PsiMember findSource(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        return (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, GrField.class, PsiClass.class});
    }

    @NotNull
    private static PsiElement[] findTargets(@NotNull PsiMember e) {
        if (e instanceof PsiClass) {
            PsiClass aClass = (PsiClass)e;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator2 = allSupers.iterator();
            while (iterator2.hasNext()) {
                PsiClass superClass = (PsiClass)iterator2.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator2.remove();
            }
            return (PsiElement[])allSupers.toArray(PsiClass.EMPTY_ARRAY);
        }
        if (e instanceof PsiMethod) {
            return GroovyGotoSuperHandler.getSupers((PsiMethod)e);
        }
        LOG.assertTrue(e instanceof GrField);
        ArrayList<PsiMethod> supers = new ArrayList<PsiMethod>();
        for (GrAccessorMethod method : GroovyPropertyUtils.getFieldAccessors((GrField)e)) {
            supers.addAll(Arrays.asList(GroovyGotoSuperHandler.getSupers(method)));
        }
        return (PsiElement[])supers.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @NotNull
    private static PsiMethod[] getSupers(PsiMethod method) {
        if (method.isConstructor()) {
            PsiMethod constructorInSuper = JavaPsiConstructorUtil.findConstructorInSuper((PsiMethod)method);
            if (constructorInSuper != null) {
                return new PsiMethod[]{constructorInSuper};
            }
        } else {
            return method.findSuperMethods(false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return file != null && ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(file.getFileType());
    }
}

