/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class GrBinaryExprInfo
implements CallInfo<GrBinaryExpression> {
    private final GrBinaryExpression myExpr;

    public GrBinaryExprInfo(GrBinaryExpression expr) {
        this.myExpr = expr;
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        return null;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        GrExpression operand = this.myExpr.getRightOperand();
        return new PsiType[]{operand != null ? operand.getType() : null};
    }

    @Override
    @Nullable
    public GrExpression getInvokedExpression() {
        return this.myExpr.getLeftOperand();
    }

    @Override
    @Nullable
    public PsiType getQualifierInstanceType() {
        return this.myExpr.getLeftOperand().getType();
    }

    @Override
    @NotNull
    public PsiElement getElementToHighlight() {
        return this.myExpr.getOperationToken();
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        return PsiImplUtil.extractUniqueResult(this.multiResolve());
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve() {
        return PsiUtilKt.multiResolve(this.myExpr);
    }

    @Override
    @NotNull
    public GrBinaryExpression getCall() {
        return this.myExpr;
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        GrExpression right = this.myExpr.getRightOperand();
        if (right != null) {
            return new GrExpression[]{right};
        }
        return GrExpression.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        return GrClosableBlock.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        return GrNamedArgument.EMPTY_ARRAY;
    }
}

