/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ConstructorCallInfo;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrListOrMapInfo
implements ConstructorCallInfo<GrListOrMap> {
    private final GrListOrMap myListOrMap;
    private final LiteralConstructorReference myReference;

    public GrListOrMapInfo(GrListOrMap listOrMap) {
        this.myListOrMap = listOrMap;
        assert (listOrMap.getReference() instanceof LiteralConstructorReference);
        this.myReference = (LiteralConstructorReference)listOrMap.getReference();
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        return null;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        if (this.myListOrMap.isMap()) {
            GrNamedArgument[] args = this.myListOrMap.getNamedArguments();
            if (args.length == 0) {
                return new PsiType[]{this.myListOrMap.getType()};
            }
            return PsiUtil.getArgumentTypes(args, GrExpression.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, true, null);
        }
        GrExpression[] args = this.myListOrMap.getInitializers();
        return PsiUtil.getArgumentTypes(GrNamedArgument.EMPTY_ARRAY, args, GrClosableBlock.EMPTY_ARRAY, true, null);
    }

    @Override
    @Nullable
    public GrExpression getInvokedExpression() {
        return null;
    }

    @Override
    @Nullable
    public PsiType getQualifierInstanceType() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement getElementToHighlight() {
        return this.myListOrMap;
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        return PsiImplUtil.extractUniqueResult(this.multiResolve());
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve() {
        GroovyResolveResult[] results = this.myReference.multiResolve(false);
        if (results.length == 1 && results[0].getElement() instanceof PsiClass) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return results;
    }

    @Override
    @NotNull
    public GrListOrMap getCall() {
        return this.myListOrMap;
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        return this.myListOrMap.isMap() ? GrExpression.EMPTY_ARRAY : this.myListOrMap.getInitializers();
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        return GrClosableBlock.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        return this.myListOrMap.isMap() ? this.myListOrMap.getNamedArguments() : GrNamedArgument.EMPTY_ARRAY;
    }
}

