/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyUncheckedAssignmentOfMemberOfRawTypeInspection
extends BaseInspection {
    @Override
    protected String buildErrorString(Object ... args) {
        PsiType expectedType = (PsiType)args[0];
        PsiType rType = (PsiType)args[1];
        return GroovyBundle.message("cannot.assign", rType.getPresentableText(), expectedType.getPresentableText());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            PsiMethod method;
            GrParameterListOwner owner;
            PsiType type2;
            GrExpression value = returnStatement.getReturnValue();
            if (value != null && (type2 = value.getType()) != null && (owner = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrParameterListOwner.class)) instanceof PsiMethod && !(method = (PsiMethod)owner).isConstructor()) {
                PsiType methodType = method.getReturnType();
                PsiType returnType2 = value.getType();
                if (methodType != null && !PsiType.VOID.equals((Object)methodType) && returnType2 != null) {
                    this.checkAssignability(methodType, value, value);
                }
            }
        }

        @Override
        public void visitNamedArgument(@NotNull GrNamedArgument argument) {
            PsiType expectedType;
            GrArgumentLabel label = argument.getLabel();
            if (label != null && (expectedType = label.getExpectedArgumentType()) != null) {
                PsiType argType;
                expectedType = TypeConversionUtil.erasure((PsiType)expectedType);
                GrExpression expr = argument.getExpression();
                if (expr != null && (argType = expr.getType()) != null) {
                    PsiClassType listType = JavaPsiFacade.getInstance((Project)argument.getProject()).getElementFactory().createTypeByFQClassName("java.util.List", argument.getResolveScope());
                    if (listType.isAssignableFrom(argType)) {
                        return;
                    }
                    this.checkAssignability(expectedType, expr, argument);
                }
            }
        }

        @Override
        public void visitVariable(@NotNull GrVariable variable) {
            PsiType rType;
            PsiType varType = variable.getType();
            GrExpression initializer = variable.getInitializerGroovy();
            if (initializer != null && (rType = initializer.getType()) != null) {
                this.checkAssignability(varType, initializer, initializer);
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
            super.visitAssignmentExpression(assignment);
            if (assignment.isOperatorAssignment()) {
                return;
            }
            GrExpression lValue = assignment.getLValue();
            if (!PsiUtil.mightBeLValue(lValue)) {
                return;
            }
            GrExpression rValue = assignment.getRValue();
            if (rValue == null) {
                return;
            }
            PsiType lType = lValue.getNominalType();
            PsiType rType = rValue.getType();
            if (PsiImplUtil.isSpreadAssignment(lValue) && lType instanceof PsiClassType) {
                PsiType[] types;
                PsiClassType pct = (PsiClassType)lType;
                PsiClass clazz = pct.resolve();
                if (clazz != null && "java.util.List".equals(clazz.getQualifiedName()) && (types = pct.getParameters()).length == 1 && types[0] != null && rType != null) {
                    this.checkAssignability(types[0], rValue, assignment);
                }
                return;
            }
            if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
                return;
            }
            if (lType != null && rType != null) {
                this.checkAssignability(lType, rValue, rValue);
            }
        }

        private void checkAssignability(PsiType lType, GrExpression rExpr, GroovyPsiElement element) {
            PsiType rType;
            if (PsiUtil.isRawClassMemberAccess(rExpr) && !TypesUtil.isAssignable(lType, rType = rExpr.getType(), element)) {
                this.registerError((PsiElement)element, lType, rType);
            }
        }
    }
}

