/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ParameterCastFix
extends GroovyFix {
    private final PsiType myType;
    private final String myName;
    private final int myPosition;

    public ParameterCastFix(int position, @NotNull PsiType type2) {
        this.myType = type2;
        this.myPosition = position;
        this.myName = GroovyBundle.message("parameter.cast.fix", position + 1, this.myType.getPresentableText());
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        GrArgumentList list;
        PsiElement element = descriptor2.getPsiElement();
        GrArgumentList grArgumentList = list = element instanceof GrArgumentList ? (GrArgumentList)element : PsiUtil.getArgumentsList(element);
        if (list == null) {
            return;
        }
        List<GrExpression> callArguments = GroovyTypeCheckVisitorHelper.getExpressionArgumentsOfCall(list);
        if (callArguments == null || this.myPosition >= callArguments.size()) {
            return;
        }
        GrExpression expression = callArguments.get(this.myPosition);
        GrCastFix.doSafeCast(project, this.myType, expression);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Add parameter cast";
    }
}

