/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GroovyAccessibilityInspection;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrAccessibilityChecker {
    private static final Logger LOG = Logger.getInstance(GrAccessibilityChecker.class);
    private final HighlightDisplayKey myDisplayKey;
    private final boolean myInspectionEnabled;

    public GrAccessibilityChecker(@NotNull GroovyFileBase file, @NotNull Project project) {
        this.myInspectionEnabled = GroovyAccessibilityInspection.isInspectionEnabled(file, project);
        this.myDisplayKey = GroovyAccessibilityInspection.findDisplayKey();
    }

    static GroovyFix[] buildFixes(PsiElement location, GroovyResolveResult resolveResult2) {
        PsiElement element = resolveResult2.getElement();
        if (!(element instanceof PsiMember)) {
            return GroovyFix.EMPTY_ARRAY;
        }
        PsiMember refElement = (PsiMember)element;
        if (refElement instanceof PsiCompiledElement) {
            return GroovyFix.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return GroovyFix.EMPTY_ARRAY;
        }
        ArrayList<GrModifierFix> fixes = new ArrayList<GrModifierFix>();
        try {
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            assert (modifierListCopy != null);
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            String minModifier = "protected";
            if (refElement.hasModifierProperty("protected")) {
                minModifier = "public";
            }
            Object[] modifiers = new String[]{"protected", "public", "packageLocal"};
            PsiClass accessObjectClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)location, PsiClass.class, (boolean)false);
            if (accessObjectClass == null) {
                PsiFile file = location.getContainingFile();
                if (!(file instanceof GroovyFile)) {
                    return GroovyFix.EMPTY_ARRAY;
                }
                accessObjectClass = ((GroovyFile)file).getScriptClass();
            }
            for (int i = ArrayUtil.indexOf((Object[])modifiers, (Object)minModifier); i < modifiers.length; ++i) {
                Object modifier = modifiers[i];
                modifierListCopy.setModifierProperty((String)modifier, true);
                if (!facade.getResolveHelper().isAccessible(refElement, modifierListCopy, location, accessObjectClass, null)) continue;
                fixes.add(new GrModifierFix(refElement, (String)modifier, true, true, GrModifierFix.MODIFIER_LIST_OWNER));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return fixes.toArray(GroovyFix.EMPTY_ARRAY);
    }

    @Nullable
    public HighlightInfo checkCodeReferenceElement(GrCodeReferenceElement ref) {
        return this.checkReferenceImpl(ref);
    }

    private HighlightInfo checkReferenceImpl(GrReferenceElement ref) {
        String constructorError;
        boolean isCompileStatic = PsiUtil.isCompileStatic(ref);
        if (!this.needToCheck(ref, isCompileStatic)) {
            return null;
        }
        PsiElement parent2 = ref.getParent();
        if (parent2 instanceof GrConstructorCall && (constructorError = GrAccessibilityChecker.checkConstructorCall((GrConstructorCall)parent2)) != null) {
            return GrAccessibilityChecker.createAnnotationForRef(ref, isCompileStatic, constructorError);
        }
        Object[] results = ref.multiResolve(false);
        boolean hasInaccessibleResults = ContainerUtil.or((Object[])results, GrAccessibilityChecker::checkResolveResult);
        if (hasInaccessibleResults) {
            String error = GroovyBundle.message("cannot.access", ref.getReferenceName());
            HighlightInfo info = GrAccessibilityChecker.createAnnotationForRef(ref, isCompileStatic, error);
            if (results.length == 1) {
                this.registerFixes(ref, (GroovyResolveResult)results[0], info);
            }
            return info;
        }
        return null;
    }

    private void registerFixes(GrReferenceElement ref, GroovyResolveResult result2, HighlightInfo info) {
        PsiElement element = result2.getElement();
        assert (element != null);
        GroovyFix[] fixes = GrAccessibilityChecker.buildFixes(ref, result2);
        if (fixes.length == 0) {
            String displayName = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)this.myDisplayKey);
            if (displayName != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new EmptyIntentionAction(displayName), (HighlightDisplayKey)this.myDisplayKey);
            }
        } else {
            ProblemDescriptor descriptor2 = InspectionManager.getInstance((Project)ref.getProject()).createProblemDescriptor(element, element, "", HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)info.getSeverity()), true, LocalQuickFix.EMPTY_ARRAY);
            for (GroovyFix fix : fixes) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new LocalQuickFixAsIntentionAdapter((LocalQuickFix)fix, descriptor2), (HighlightDisplayKey)this.myDisplayKey);
            }
        }
    }

    @Nullable
    public HighlightInfo checkReferenceExpression(GrReferenceExpression ref) {
        return this.checkReferenceImpl(ref);
    }

    private static boolean checkResolveResult(GroovyResolveResult result2) {
        return result2 != null && result2.getElement() != null && !result2.isAccessible();
    }

    private boolean needToCheck(GrReferenceElement ref, boolean isCompileStatic) {
        if (isCompileStatic) {
            return true;
        }
        if (!this.myInspectionEnabled) {
            return false;
        }
        return !GroovyAccessibilityInspection.isSuppressed(ref);
    }

    private static String checkConstructorCall(GrConstructorCall constructorCall) {
        GroovyResolveResult result2 = constructorCall.advancedResolve();
        if (GrAccessibilityChecker.checkResolveResult(result2)) {
            return GroovyBundle.message("cannot.access", PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)result2.getElement()), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2));
        }
        return null;
    }

    @Nullable
    private static HighlightInfo createAnnotationForRef(@NotNull GrReferenceElement ref, boolean strongError, @NotNull String message) {
        HighlightDisplayLevel displayLevel = strongError ? HighlightDisplayLevel.ERROR : GroovyAccessibilityInspection.getHighlightDisplayLevel(ref.getProject(), ref);
        return GrInspectionUtil.createAnnotationForRef(ref, displayLevel, message);
    }
}

