/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyLabeledStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("label.already.used", args);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return GroovyInspectionBundle.message("check.labeled.statement", new Object[0]);
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
            super.visitLabeledStatement(labeledStatement);
            String name = labeledStatement.getName();
            GrLabeledStatement existing = ResolveUtil.resolveLabeledStatement(name, labeledStatement, true);
            if (existing != null && PsiTreeUtil.isAncestor((PsiElement)existing, (PsiElement)labeledStatement, (boolean)true)) {
                this.registerError(labeledStatement.getLabel(), name);
            }
        }
    }
}

