/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class AsTypeTransformation
extends Transformation<GrSafeCastExpression> {
    @Override
    @Nullable
    protected GrSafeCastExpression checkCast(@NotNull GrExpression expression) {
        return expression instanceof GrSafeCastExpression ? (GrSafeCastExpression)expression : null;
    }

    @Override
    protected boolean couldApply(@NotNull GrSafeCastExpression expression) {
        GrTypeElement typeElement = expression.getCastTypeElement();
        if (typeElement == null) {
            return false;
        }
        PsiType type2 = typeElement.getType();
        return type2 instanceof PsiClassType && ((PsiClassType)type2).getParameterCount() == 0;
    }

    @Override
    protected void apply(@NotNull GrSafeCastExpression expression) {
        GrExpression lhsParenthesized = this.addParenthesesIfNeeded(expression.getOperand());
        GrTypeElement typeElement = Objects.requireNonNull(expression.getCastTypeElement());
        GrInspectionUtil.replaceExpression(expression, String.format("%s.asType(%s)", lhsParenthesized.getText(), typeElement.getText()));
    }

    @Override
    public String getMethod() {
        return "asType";
    }
}

