/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

class AsBooleanTransformation
extends Transformation {
    public static final String NEGATION = GroovyTokenTypes.mLNOT.toString();
    public static final String DOUBLE_NEGATION = NEGATION + NEGATION;

    AsBooleanTransformation() {
    }

    @Nullable
    protected String getPrefix(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (AsBooleanTransformation.isImplicitlyBoolean(methodCall)) {
            return "";
        }
        if (options.useDoubleNegation()) {
            return DOUBLE_NEGATION;
        }
        return null;
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrInspectionUtil.replaceExpression(methodCall, this.getPrefix(methodCall, options) + Objects.requireNonNull(AsBooleanTransformation.getBase(methodCall)).getText());
    }

    @Override
    public boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        return AsBooleanTransformation.getBase(methodCall) != null && methodCall.getExpressionArguments().length == 0 && this.getPrefix(methodCall, options) != null && methodCall.getClosureArguments().length == 0;
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        String prefix = this.getPrefix(methodCall, options);
        return DOUBLE_NEGATION.equals(prefix) && ParenthesesUtils.checkPrecedence(ParenthesesUtils.PREFIX_PRECEDENCE, (GrExpression)methodCall);
    }

    private static boolean isImplicitlyBoolean(GrMethodCall methodCall) {
        PsiElement parent2 = methodCall.getParent();
        if (parent2 instanceof GrIfStatement || parent2 instanceof GrWhileStatement) {
            return true;
        }
        if (parent2 instanceof GrConditionalExpression && ((GrConditionalExpression)parent2).getCondition().equals(methodCall)) {
            return true;
        }
        if (parent2 instanceof GrUnaryExpression && PsiType.BOOLEAN.equals((Object)((GrUnaryExpression)parent2).getType())) {
            return true;
        }
        return parent2 instanceof GrBinaryExpression && PsiType.BOOLEAN.equals((Object)((GrBinaryExpression)parent2).getType());
    }
}

