/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.SimpleBinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class AsTypeTransformation
extends SimpleBinaryTransformation {
    public AsTypeTransformation() {
        super(GroovyTokenTypes.kAS);
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrExpression rhsQualifierExpression;
        GrReferenceExpression rhs = (GrReferenceExpression)this.getRhs(methodCall);
        GrExpression grExpression = rhsQualifierExpression = rhs.isQualified() ? rhs.getQualifierExpression() : rhs;
        if (rhsQualifierExpression == null) {
            return;
        }
        GrInspectionUtil.replaceExpression(methodCall, String.format("%s %s %s", this.getLhs(methodCall).getText(), GroovyTokenTypes.kAS, rhsQualifierExpression.getText()));
    }

    @Override
    public boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (!super.couldApplyInternal(methodCall, options)) {
            return false;
        }
        GrExpression rhs = this.getRhs(methodCall);
        return ResolveUtil.resolvesToClass(rhs);
    }
}

