/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public class EqualsTransformation
extends BinaryTransformation {
    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrExpression rhs = this.getRhs(methodCall);
        GrExpression rhsParenthesized = ParenthesesUtils.checkPrecedenceForBinaryOps(ParenthesesUtils.getPrecedence(rhs), GroovyTokenTypes.mEQUAL, true) ? ParenthesesUtils.parenthesize(rhs) : rhs;
        GrExpression replacedElement = methodCall;
        String operator = "==";
        if (BoolUtils.isNegation(methodCall.getParent())) {
            replacedElement = (GrExpression)methodCall.getParent();
            operator = "!=";
        }
        GrInspectionUtil.replaceExpression(replacedElement, String.format("%s %s %s", this.getLhs(methodCall).getText(), operator, rhsParenthesized.getText()));
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrExpression rhs = this.getRhs(methodCall);
        return ParenthesesUtils.checkPrecedenceForBinaryOps(ParenthesesUtils.getPrecedence(rhs), GroovyTokenTypes.mEQUAL, true) || ParenthesesUtils.checkPrecedence(ParenthesesUtils.EQUALITY_PRECEDENCE, (GrExpression)methodCall);
    }
}

