/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

class PutAtTransformation
extends Transformation {
    PutAtTransformation() {
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrExpression base = Objects.requireNonNull(PutAtTransformation.getBase(methodCall));
        GrExpression key = this.getArgument(methodCall, 0);
        GrExpression rhs = this.getArgument(methodCall, 1);
        rhs = ParenthesesUtils.checkPrecedenceForNonBinaryOps(rhs, 16) ? ParenthesesUtils.parenthesize(rhs) : rhs;
        String result2 = String.format("%s[%s] = %s", base.getText(), key.getText(), rhs.getText());
        GrInspectionUtil.replaceExpression(methodCall, result2);
    }

    @Override
    public boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        return PutAtTransformation.getBase(methodCall) != null & this.checkArgumentsCount(methodCall, 2);
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrExpression rhs = methodCall.getExpressionArguments()[1];
        return ParenthesesUtils.checkPrecedenceForNonBinaryOps(rhs, 16) || ParenthesesUtils.checkPrecedence(16, (GrExpression)methodCall);
    }
}

