/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public class SimpleBinaryTransformation
extends BinaryTransformation {
    private final IElementType myOperator;

    public SimpleBinaryTransformation(@NotNull IElementType operatorType) {
        this.myOperator = operatorType;
    }

    @NotNull
    protected String getOperatorText() {
        return this.myOperator.toString();
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrExpression rhs = this.getRhs(methodCall);
        rhs = ParenthesesUtils.checkPrecedenceForBinaryOps(ParenthesesUtils.getPrecedence(rhs), this.myOperator, true) ? ParenthesesUtils.parenthesize(rhs) : rhs;
        GrInspectionUtil.replaceExpression(methodCall, String.format("%s %s %s", this.getLhs(methodCall).getText(), this.getOperatorText(), rhs.getText()));
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        GrExpression rhs = this.getRhs(methodCall);
        int rhsPrecedence = ParenthesesUtils.getPrecedence(rhs);
        return ParenthesesUtils.checkPrecedenceForBinaryOps(rhsPrecedence, this.myOperator, true) || ParenthesesUtils.checkPrecedence(ParenthesesUtils.precedenceForBinaryOperator(this.myOperator), (GrExpression)methodCall);
    }
}

