/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public abstract class Transformation {
    public boolean couldApply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        return this.couldApplyInternal(methodCall, options) && (!options.withoutAdditionalParentheses() || !this.needParentheses(methodCall, options));
    }

    protected abstract boolean couldApplyInternal(@NotNull GrMethodCall var1, @NotNull ChangeToOperatorInspection.Options var2);

    protected abstract boolean needParentheses(@NotNull GrMethodCall var1, @NotNull ChangeToOperatorInspection.Options var2);

    public abstract void apply(@NotNull GrMethodCall var1, @NotNull ChangeToOperatorInspection.Options var2);

    @Nullable
    public static GrExpression getBase(@NotNull GrMethodCall callExpression) {
        GrExpression expression = callExpression.getInvokedExpression();
        GrReferenceExpression invokedExpression = (GrReferenceExpression)expression;
        GrExpression qualifier = invokedExpression.getQualifierExpression();
        if (PsiUtilKt.isSuperExpression(qualifier)) {
            return null;
        }
        return qualifier;
    }

    public boolean checkArgumentsCount(@NotNull GrMethodCall callExpression, int count) {
        if (callExpression.getNamedArguments().length != 0) {
            return false;
        }
        return callExpression.getExpressionArguments().length + callExpression.getClosureArguments().length == count;
    }

    @NotNull
    public GrExpression getArgument(@NotNull GrMethodCall callExpression, int index) {
        GrExpression[] expressionArguments = callExpression.getExpressionArguments();
        if (index < expressionArguments.length) {
            return expressionArguments[index];
        }
        return callExpression.getClosureArguments()[index - expressionArguments.length];
    }
}

