/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.confusing.ClashingTraitMethodsInspectionBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;

public class ClashingTraitMethodsInspection
extends ClashingTraitMethodsInspectionBase {
    @Override
    @NotNull
    protected LocalQuickFix getFix() {
        return new MyQuickFix();
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        @NotNull
        public String getName() {
            return GroovyInspectionBundle.message("declare.explicit.implementations.of.trait", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return "Declare explicit implementation of clashing traits";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof GrTypeDefinition && ((GrTypeDefinition)parent2).getNameIdentifierGroovy() == element) {
                GrTypeDefinition aClass = (GrTypeDefinition)parent2;
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{aClass.getContainingFile()}).run(() -> {
                    List<ClashingTraitMethodsInspectionBase.ClashingMethod> clashingMethods = ClashingTraitMethodsInspectionBase.collectClassingMethods(aClass);
                    for (ClashingTraitMethodsInspectionBase.ClashingMethod method : clashingMethods) {
                        PsiMethod traitMethod = method.getSignature().getMethod();
                        ClashingTraitMethodsInspectionBase.LOG.assertTrue(traitMethod instanceof GrTraitMethod);
                        OverrideImplementUtil.overrideOrImplement((PsiClass)aClass, (PsiMethod)traitMethod);
                    }
                });
            }
        }
    }
}

