/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public abstract class ClashingTraitMethodsInspectionBase
extends BaseInspection {
    protected static final Logger LOG = Logger.getInstance(ClashingTraitMethodsInspectionBase.class);

    @NotNull
    protected static List<ClashingMethod> collectClassingMethods(@NotNull GrTypeDefinition typeDefinition) {
        Collection visibleSignatures = typeDefinition.getVisibleSignatures();
        ArrayList clashingMethods = ContainerUtil.newArrayList();
        for (HierarchicalMethodSignature signature : visibleSignatures) {
            List superSignatures;
            PsiMethod method = signature.getMethod();
            if (!(method instanceof GrTraitMethod) || method.getContainingClass() != typeDefinition || (superSignatures = signature.getSuperSignatures()).size() <= 1) continue;
            ArrayList traits = ContainerUtil.newArrayList();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                PsiMethod superMethod = superSignature.getMethod();
                PsiClass superClass = superMethod.getContainingClass();
                if (!GrTraitUtil.isTrait(superClass) || superMethod.getModifierList().hasExplicitModifier("abstract")) continue;
                traits.add((GrTypeDefinition)superClass);
            }
            if (traits.size() <= 1) continue;
            clashingMethods.add(new ClashingMethod(signature, traits));
        }
        return clashingMethods;
    }

    @NotNull
    private static List<PsiClass> collectImplementedTraits(@NotNull GrTypeDefinition typeDefinition) {
        return ContainerUtil.findAll((Object[])typeDefinition.getSupers(), aClass -> GrTraitUtil.isTrait(aClass));
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                super.visitTypeDefinition(typeDefinition);
                List superTraits = ClashingTraitMethodsInspectionBase.collectImplementedTraits(typeDefinition);
                if (superTraits.size() < 2) {
                    return;
                }
                List<ClashingMethod> clashingMethods = ClashingTraitMethodsInspectionBase.collectClassingMethods(typeDefinition);
                for (ClashingMethod clashing : clashingMethods) {
                    this.registerError(typeDefinition.getNameIdentifierGroovy(), this.buildWarning(clashing), new LocalQuickFix[]{ClashingTraitMethodsInspectionBase.this.getFix()}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @NotNull
            private String buildWarning(@NotNull ClashingMethod entry) {
                return "Traits " + this.buildTraitString(entry) + " contain clashing methods with signature " + this.buildSignatureString(entry);
            }

            @NotNull
            private String buildSignatureString(@NotNull ClashingMethod entry) {
                HierarchicalMethodSignature signature = entry.getSignature();
                return PsiFormatUtil.formatMethod((PsiMethod)signature.getMethod(), (PsiSubstitutor)signature.getSubstitutor(), (int)257, (int)2);
            }

            @NotNull
            private String buildTraitString(@NotNull ClashingMethod entry) {
                return StringUtil.join(entry.getSuperTraits(), tr -> tr.getName(), (String)", ");
            }
        };
    }

    @NotNull
    protected LocalQuickFix getFix() {
        return GroovyFix.EMPTY_FIX;
    }

    protected static class ClashingMethod {
        private final HierarchicalMethodSignature mySignature;
        private final List<GrTypeDefinition> mySuperTraits;

        public ClashingMethod(@NotNull HierarchicalMethodSignature signature, @NotNull List<GrTypeDefinition> superTraits) {
            this.mySignature = signature;
            this.mySuperTraits = superTraits;
        }

        @NotNull
        public HierarchicalMethodSignature getSignature() {
            return this.mySignature;
        }

        @NotNull
        public List<GrTypeDefinition> getSuperTraits() {
            return this.mySuperTraits;
        }
    }
}

