/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GrDeprecatedAPIUsageInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return GroovyInspectionBundle.message("gr.deprecated.api.usage", new Object[0]);
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
                super.visitReferenceExpression(ref);
                this.checkRef(ref);
            }

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement ref) {
                super.visitCodeReferenceElement(ref);
                this.checkRef(ref);
            }

            private void checkRef(GrReferenceElement ref) {
                PsiElement resolved = ref.resolve();
                if (this.isDeprecated(resolved)) {
                    PsiElement toHighlight = this.getElementToHighlight(ref);
                    this.registerError(toHighlight, GroovyBundle.message("0.is.deprecated", ref.getReferenceName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_DEPRECATED);
                }
            }

            @NotNull
            public PsiElement getElementToHighlight(@NotNull GrReferenceElement refElement) {
                PsiElement refNameElement = refElement.getReferenceNameElement();
                return refNameElement != null ? refNameElement : refElement;
            }

            private boolean isDeprecated(PsiElement resolved) {
                if (resolved instanceof PsiDocCommentOwner) {
                    return ((PsiDocCommentOwner)resolved).isDeprecated();
                }
                return resolved instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)((PsiModifierListOwner)resolved));
            }
        };
    }
}

