/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyNegatedConditionalInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Negated conditional expression";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Negated conditional expression #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression grConditionalExpression) {
            super.visitConditionalExpression(grConditionalExpression);
            GrExpression condition = grConditionalExpression.getCondition();
            if (!BoolUtils.isNegation(condition)) {
                return;
            }
            this.registerError(grConditionalExpression);
        }
    }
}

