/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;

public class GroovyNestedSwitchInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Nested switch statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Nested #ref statement #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
            super.visitSwitchStatement(switchStatement);
            GrSwitchStatement containingSwitch = (GrSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)switchStatement, GrSwitchStatement.class);
            if (containingSwitch == null) {
                return;
            }
            this.registerStatementError(switchStatement, new Object[0]);
        }
    }
}

