/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConstantIfStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        return "Constant if statement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        return "#ref statement can be simplified #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new ConstantIfStatementFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            super.visitIfStatement(statement);
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (GroovyConstantIfStatementInspection.isTrue(condition) || GroovyConstantIfStatementInspection.isFalse(condition)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }
    }

    private static class ConstantIfStatementFix
    extends GroovyFix {
        private ConstantIfStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor2.getPsiElement();
            GrIfStatement ifStatement = (GrIfStatement)ifKeyword.getParent();
            assert (ifStatement != null);
            GrStatement thenBranch = ifStatement.getThenBranch();
            GrStatement elseBranch = ifStatement.getElseBranch();
            GrExpression condition = ifStatement.getCondition();
            if (GroovyConstantIfStatementInspection.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, (GrStatement)elseBranch.copy());
                } else {
                    ifStatement.delete();
                }
            } else {
                ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, (GrStatement)thenBranch.copy());
            }
        }
    }
}

